/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.merge.MergePolicy;
import org.hibernate.cache.entry.CacheEntry;

public class VersionAwareMergePolicy
implements MergePolicy {
    public static final String NAME = "hz.HIBERNATE_VERSION_AWARE";

    public Object merge(String mapName, MapEntry mergingEntry, MapEntry existingEntry) {
        DataRecordEntry mergingDataEntry = (DataRecordEntry)mergingEntry;
        if (!mergingDataEntry.isValid()) {
            return REMOVE_EXISTING;
        }
        Object existingObject = existingEntry != null ? existingEntry.getValue() : null;
        Object mergingObject = mergingEntry.getValue();
        if (existingObject != null && existingObject instanceof CacheEntry && mergingObject != null && mergingObject instanceof CacheEntry) {
            CacheEntry existing = existingObject;
            CacheEntry merging = (CacheEntry)mergingObject;
            Object mergingVersionObject = merging.getVersion();
            Object existingVersionObject = existing.getVersion();
            if (mergingVersionObject != null && existingVersionObject != null && mergingVersionObject instanceof Comparable && existingVersionObject instanceof Comparable) {
                Comparable mergingVersion = (Comparable)mergingVersionObject;
                Comparable existingVersion = (Comparable)existingVersionObject;
                if (mergingVersion.compareTo(existingVersion) > 0) {
                    return mergingDataEntry.getValueData();
                }
                return ((DataRecordEntry)existingEntry).getValueData();
            }
        }
        return mergingDataEntry.getValueData();
    }
}

