/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.Call;
import com.hazelcast.client.ClientMapEntry;
import com.hazelcast.client.EntryHolder;
import com.hazelcast.client.GuavaNearCacheImpl;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LightEntrySetSet;
import com.hazelcast.client.LightKeySet;
import com.hazelcast.client.NearCache;
import com.hazelcast.client.Packet;
import com.hazelcast.client.ProxyHelper;
import com.hazelcast.client.ValueCollection;
import com.hazelcast.client.impl.EntryListenerManager;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ClusterOperation;
import com.hazelcast.impl.Keys;
import com.hazelcast.impl.base.KeyValue;
import com.hazelcast.impl.base.Pairs;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.DistributedTimeoutException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapClientProxy<K, V>
implements IMap<K, V>,
EntryHolder {
    final ProxyHelper proxyHelper;
    private final String name;
    final NearCache<K, V> nearCache;
    private static String PROP_CLIENT_NEAR_CACHE_CONFIG_ENABLED = "hazelcast.client.near.cache.enabled";

    public MapClientProxy(HazelcastClient client, String name) {
        this.name = name;
        this.proxyHelper = new ProxyHelper(name, client);
        Config config = (Config)this.proxyHelper.doOp(ClusterOperation.GET_CONFIG, null, null);
        MapConfig mapConfig = config.getMapConfig(name);
        NearCacheConfig ncc = mapConfig.getNearCacheConfig();
        boolean nearCacheEnabled = "true".equalsIgnoreCase(System.getProperty(PROP_CLIENT_NEAR_CACHE_CONFIG_ENABLED, "false"));
        NearCache nearCache = this.nearCache = nearCacheEnabled && ncc != null ? new GuavaNearCacheImpl(ncc, this) : null;
        if (this.nearCache != null && ncc.isInvalidateOnChange()) {
            this.addEntryListener(new EntryListener<K, V>(){

                @Override
                public void entryAdded(EntryEvent<K, V> kvEntryEvent) {
                    MapClientProxy.this.nearCache.invalidate(kvEntryEvent.getKey());
                }

                @Override
                public void entryRemoved(EntryEvent<K, V> kvEntryEvent) {
                    MapClientProxy.this.nearCache.invalidate(kvEntryEvent.getKey());
                }

                @Override
                public void entryUpdated(EntryEvent<K, V> kvEntryEvent) {
                    MapClientProxy.this.nearCache.invalidate(kvEntryEvent.getKey());
                }

                @Override
                public void entryEvicted(EntryEvent<K, V> kvEntryEvent) {
                    MapClientProxy.this.nearCache.invalidate(kvEntryEvent.getKey());
                }
            }, false);
        }
    }

    @Override
    public void addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("client doesn't support local entry listener");
    }

    @Override
    public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        this.addEntryListener(listener, null, includeValue);
    }

    @Override
    public void addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        ProxyHelper.check(listener);
        Boolean noEntryListenerRegistered = this.listenerManager().noListenerRegistered(key, this.name, includeValue);
        if (noEntryListenerRegistered == null) {
            this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, key, null);
            noEntryListenerRegistered = Boolean.TRUE;
        }
        if (noEntryListenerRegistered.booleanValue()) {
            Call c = this.listenerManager().createNewAddListenerCall(this.proxyHelper, key, includeValue);
            this.proxyHelper.doCall(c);
        }
        this.listenerManager().registerListener(this.name, key, includeValue, listener);
    }

    @Override
    public void removeEntryListener(EntryListener<K, V> listener) {
        ProxyHelper.check(listener);
        this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, null, null);
        this.listenerManager().removeListener(this.name, null, listener);
    }

    @Override
    public void removeEntryListener(EntryListener<K, V> listener, K key) {
        ProxyHelper.check(listener);
        ProxyHelper.check(key);
        this.proxyHelper.doOp(ClusterOperation.REMOVE_LISTENER, key, null);
        this.listenerManager().removeListener(this.name, key, listener);
    }

    private EntryListenerManager listenerManager() {
        return this.proxyHelper.getHazelcastClient().getListenerManager().getEntryListenerManager();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        Collection collection = this.proxyHelper.entries(predicate);
        return new LightEntrySetSet(collection, this, this.getInstanceType());
    }

    @Override
    public void flush() {
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_FLUSH, null, null);
    }

    @Override
    public boolean evict(Object key) {
        ProxyHelper.check(key);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_EVICT, key, null);
    }

    @Override
    public MapEntry<K, V> getMapEntry(K key) {
        ProxyHelper.check(key);
        CMap.CMapEntry cMapEntry = (CMap.CMapEntry)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_GET_MAP_ENTRY, key, null);
        if (cMapEntry == null) {
            return null;
        }
        return new ClientMapEntry(cMapEntry, key, this);
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        Collection collection = this.proxyHelper.keys(predicate);
        return new LightKeySet(this, new HashSet(collection));
    }

    @Override
    public boolean lockMap(long time, TimeUnit timeunit) {
        ProxyHelper.checkTime(time, timeunit);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK_MAP, null, time, timeunit);
    }

    @Override
    public void unlockMap() {
        this.doLock(ClusterOperation.CONCURRENT_MAP_UNLOCK_MAP, null, -1L, null);
    }

    @Override
    public void lock(K key) {
        ProxyHelper.check(key);
        this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, -1L, null);
    }

    @Override
    public boolean isLocked(K key) {
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_IS_KEY_LOCKED, key, -1L, null);
    }

    @Override
    public boolean tryLock(K key) {
        ProxyHelper.check(key);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, 0L, null);
    }

    @Override
    public V tryLockAndGet(K key, long timeout, TimeUnit timeunit) throws TimeoutException {
        ProxyHelper.check(key);
        Object result = this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_TRY_LOCK_AND_GET, key, null, timeout, timeunit);
        if (result instanceof DistributedTimeoutException) {
            throw new TimeoutException();
        }
        return (V)result;
    }

    @Override
    public void putAndUnlock(K key, V value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_AND_UNLOCK, key, value);
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.checkTime(time, timeunit);
        return (Boolean)this.doLock(ClusterOperation.CONCURRENT_MAP_LOCK, key, time, timeunit);
    }

    @Override
    public void unlock(K key) {
        ProxyHelper.check(key);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_UNLOCK, key, null);
    }

    @Override
    public void forceUnlock(K key) {
        ProxyHelper.check(key);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_FORCE_UNLOCK, key, null);
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        Set<Map.Entry<K, V>> set = this.entrySet(predicate);
        return new ValueCollection<K, V>(this, set);
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, key, value, ttl, timeunit);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_IF_ABSENT, key, value);
    }

    @Override
    public boolean remove(Object arg0, Object arg1) {
        ProxyHelper.check(arg0);
        ProxyHelper.check(arg1);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE_IF_SAME, arg0, arg1);
    }

    @Override
    public V replace(K arg0, V arg1) {
        ProxyHelper.check(arg0);
        ProxyHelper.check(arg1);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_NOT_NULL, arg0, arg1);
    }

    @Override
    public boolean replace(K arg0, V arg1, V arg2) {
        ProxyHelper.check(arg0);
        ProxyHelper.check(arg1);
        ProxyHelper.check(arg2);
        Keys keys = new Keys();
        keys.getKeys().add(IOUtil.toData(arg1));
        keys.getKeys().add(IOUtil.toData(arg2));
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REPLACE_IF_SAME, arg0, keys);
    }

    @Override
    public void clear() {
        Set<K> keys = this.keySet();
        for (K key : keys) {
            this.remove(key);
        }
    }

    @Override
    public boolean containsKey(Object arg0) {
        ProxyHelper.check(arg0);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_KEY, arg0, null);
    }

    @Override
    public boolean containsValue(Object arg0) {
        ProxyHelper.check(arg0);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_CONTAINS_VALUE, null, arg0);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null);
    }

    @Override
    public V get(Object key) {
        if (this.nearCache != null) {
            return this.nearCache.get(key);
        }
        return this.get0(key);
    }

    protected V get0(Object key) {
        ProxyHelper.check(key);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_GET, key, null);
    }

    @Override
    public Map<K, V> getAll(Set<K> setKeys) {
        Keys keys = new Keys();
        for (K key : setKeys) {
            keys.add(IOUtil.toData(key));
        }
        Pairs pairs = (Pairs)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_GET_ALL, keys, null);
        List<KeyValue> lsKeyValues = pairs.getKeyValues();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (lsKeyValues != null) {
            for (KeyValue keyValue : lsKeyValues) {
                map.put(IOUtil.toObject(keyValue.getKeyData()), IOUtil.toObject(keyValue.getValueData()));
            }
        }
        return map;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(null);
    }

    @Override
    public Future<V> getAsync(K key) {
        ProxyHelper.check(key);
        return this.proxyHelper.doAsync(ClusterOperation.CONCURRENT_MAP_GET, key, null);
    }

    @Override
    public Future<V> putAsync(K key, V value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return this.proxyHelper.doAsync(ClusterOperation.CONCURRENT_MAP_PUT, key, value);
    }

    @Override
    public Future<V> removeAsync(K key) {
        ProxyHelper.check(key);
        return this.proxyHelper.doAsync(ClusterOperation.CONCURRENT_MAP_REMOVE, key, null);
    }

    @Override
    public V put(K key, V value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT, key, value);
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT, key, value, ttl, timeunit);
    }

    @Override
    public void set(K key, V value) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SET, key, value, -1L, null);
    }

    @Override
    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SET, key, value, ttl, timeunit);
    }

    @Override
    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_TRANSIENT, key, value, ttl, timeunit);
    }

    @Override
    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        ProxyHelper.check(key);
        ProxyHelper.check(value);
        return (Boolean)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_TRY_PUT, key, value, timeout, timeunit);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Pairs pairs = new Pairs(map.size());
        for (K key : map.keySet()) {
            V value = map.get(key);
            pairs.addKeyValue(new KeyValue(IOUtil.toData(key), IOUtil.toData(value)));
        }
        this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_PUT_ALL, null, pairs);
    }

    @Override
    public V remove(Object arg0) {
        ProxyHelper.check(arg0);
        return (V)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_REMOVE, arg0, null);
    }

    @Override
    public Object tryRemove(K key, long timeout, TimeUnit timeunit) throws TimeoutException {
        ProxyHelper.check(key);
        Object result = this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_TRY_REMOVE, key, null, timeout, timeunit);
        if (result instanceof DistributedTimeoutException) {
            throw new TimeoutException();
        }
        return result;
    }

    private Object doLock(ClusterOperation operation, Object key, long timeout, TimeUnit timeUnit) {
        Packet request = this.proxyHelper.prepareRequest(operation, key, (Object)timeUnit);
        request.setTimeout(timeout);
        Packet response = this.proxyHelper.callAndGetResult(request);
        return ProxyHelper.getValue(response);
    }

    @Override
    public int size() {
        return (Integer)this.proxyHelper.doOp(ClusterOperation.CONCURRENT_MAP_SIZE, null, null);
    }

    @Override
    public Collection<V> values() {
        return this.values(null);
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public Instance.InstanceType getInstanceType() {
        return Instance.InstanceType.MAP;
    }

    @Override
    public void addIndex(String attribute, boolean ordered) {
        this.proxyHelper.doOp(ClusterOperation.ADD_INDEX, attribute, ordered);
    }

    @Override
    public void addIndex(Expression<?> expression, boolean ordered) {
        this.proxyHelper.doOp(ClusterOperation.ADD_INDEX, expression, ordered);
    }

    @Override
    public String getName() {
        return this.name.substring("c:".length());
    }

    @Override
    public void destroy() {
        this.proxyHelper.destroy();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IMap) {
            return this.getName().equals(((IMap)o).getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public NearCache<K, V> getNearCache() {
        return this.nearCache;
    }
}

