/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.Serializable;

public class StatsSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String title;
    private double total = 0.0;
    private double latest = 0.0;
    private double min = Double.POSITIVE_INFINITY;
    private double max = 0.0;
    private double avg = 0.0;

    public StatsSnapshot(String title) {
        this.title = title;
    }

    public void newValues(long time, long count, long totalCount) {
        this.total += (double)time;
        if (count > 0L) {
            this.latest = (double)time / (double)count;
            if (this.latest > this.max) {
                this.max = this.latest;
            }
            if (this.latest < this.min) {
                this.min = this.latest;
            }
            if (totalCount > 0L) {
                this.avg = this.total / (double)totalCount;
            }
        }
    }

    public void newValues(long updateCount, long totalUpdates) {
        this.total += (double)updateCount;
        this.latest = updateCount;
        if (this.latest > this.max) {
            this.max = this.latest;
        }
        if (this.latest < this.min) {
            this.min = this.latest;
        }
        this.avg = this.total / (double)(totalUpdates + 1L);
    }

    public StatsSnapshot copy() {
        StatsSnapshot ts = new StatsSnapshot(this.title);
        ts.setTotal(this.total);
        ts.setLatest(this.latest);
        ts.setMin(this.min);
        ts.setMax(this.max);
        ts.setAvg(this.avg);
        return ts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.title).append(": total=").append(this.total);
        sb.append(", latest=").append(this.latest);
        sb.append(", min=").append(this.getMin());
        sb.append(", max=").append(this.getMax());
        sb.append(", avg=").append(this.getAvg());
        return sb.toString();
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public double getTotal() {
        return this.total;
    }

    public void setLatest(double latest) {
        this.latest = latest;
    }

    public double getLatest() {
        return this.latest;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMin() {
        if (Double.compare(this.min, Double.POSITIVE_INFINITY) == 0) {
            return this.latest;
        }
        return this.min;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMax() {
        return this.max;
    }

    public void setAvg(double avg) {
        this.avg = avg;
    }

    public double getAvg() {
        return this.avg;
    }
}

