/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import org.jppf.server.protocol.JPPFRunnable;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.StringUtils;

public class ReflectionUtils {
    public static String dumpObject(Object o, String ... names) {
        return ReflectionUtils.dumpObject(o, ", ", true, false, names);
    }

    public static String dumpObject(Object o, String separator, boolean displaySimpleClassName, boolean displayHashCode, String ... names) {
        LinkedHashSet fieldNames = new LinkedHashSet();
        if (names != null) {
            Collections.addAll(fieldNames, names);
        }
        if (o == null) {
            return "null";
        }
        Class<?> clazz = o.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append(displaySimpleClassName ? clazz.getSimpleName() : clazz.getName());
        if (displayHashCode) {
            sb.append('@').append(Integer.toHexString(o.hashCode()));
        }
        sb.append('[');
        Method[] methods = clazz.getMethods();
        AbstractMap attrMap = fieldNames.isEmpty() ? new TreeMap() : new HashMap(names.length);
        for (Method method : methods) {
            if (!ReflectionUtils.isGetter(method) || "getClass".equals(method.getName())) continue;
            String attrName = null;
            attrName = method.getName().substring(method.getName().startsWith("get") ? 3 : 2);
            attrName = attrName.substring(0, 1).toLowerCase() + attrName.substring(1);
            if (!fieldNames.isEmpty() && !fieldNames.contains(attrName)) continue;
            Object value = null;
            try {
                value = method.invoke(o, (Object[])null);
                if (value == null) {
                    value = "null";
                }
            }
            catch (Exception e) {
                value = "*Error: " + ExceptionUtils.getMessage((Throwable)e) + '*';
            }
            attrMap.put(attrName, value);
        }
        int count = 0;
        Set<Object> set = fieldNames.isEmpty() ? attrMap.keySet() : fieldNames;
        for (String string : set) {
            Object value = attrMap.get(string);
            if (value == null) continue;
            if (count++ > 0) {
                sb.append(separator);
            }
            sb.append(string).append('=').append(value);
        }
        sb.append(']');
        return sb.toString();
    }

    public static boolean isGetter(Method meth) {
        Class<?> type = meth.getReturnType();
        if (Void.TYPE.equals(type)) {
            return false;
        }
        if (!StringUtils.startsWithOneOf((String)meth.getName(), (boolean)false, (String[])new String[]{"get", "is"})) {
            return false;
        }
        if (meth.getName().startsWith("is") && !Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
            return false;
        }
        Class<?>[] paramTypes = meth.getParameterTypes();
        return paramTypes == null || paramTypes.length <= 0;
    }

    public static boolean isSetter(Method meth) {
        Class<?> type = meth.getReturnType();
        if (!Void.TYPE.equals(type)) {
            return false;
        }
        if (!meth.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = meth.getParameterTypes();
        return paramTypes != null && paramTypes.length == 1;
    }

    public static Method getGetter(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        Method getter = null;
        for (Method method : methods) {
            if (!ReflectionUtils.isGetter(method) || !name.equals(method.getName())) continue;
            getter = method;
            break;
        }
        return getter;
    }

    public static Method getSetter(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        Method setter = null;
        for (Method method : methods) {
            if (!ReflectionUtils.isSetter(method) || !name.equals(method.getName())) continue;
            setter = method;
            break;
        }
        return setter;
    }

    public static Method getGetterForAttribute(Class clazz, String attrName) {
        String basename = attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
        Method method = ReflectionUtils.getGetter(clazz, "get" + basename);
        if (method == null) {
            method = ReflectionUtils.getGetter(clazz, "is" + basename);
        }
        return method;
    }

    public static Method getSetterForAttribute(Class clazz, String attrName) {
        String basename = attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
        return ReflectionUtils.getSetter(clazz, "set" + basename);
    }

    public static Method[] getAllBeanMethods(Class clazz, boolean getters) {
        Method[] allMethods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method meth : allMethods = clazz.getMethods()) {
            if ((!getters || !ReflectionUtils.isGetter(meth)) && (getters || !ReflectionUtils.isSetter(meth))) continue;
            methodList.add(meth);
        }
        return methodList.toArray(new Method[methodList.size()]);
    }

    public static Object deepCopy(Object o) {
        return null;
    }

    public static boolean isJPPFAnnotated(Class<?> clazz) {
        return ReflectionUtils.getJPPFAnnotatedElement(clazz) != null;
    }

    public static AnnotatedElement getJPPFAnnotatedElement(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!ReflectionUtils.isJPPFAnnotated(method)) continue;
            return method;
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            if (!ReflectionUtils.isJPPFAnnotated(executable)) continue;
            return executable;
        }
        return null;
    }

    public static boolean isJPPFAnnotated(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        if (annotatedElement == null) {
            return false;
        }
        for (Annotation a : annotations = annotatedElement.getAnnotations()) {
            if (!JPPFRunnable.class.equals(a.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static Method getMatchingMethod(Class clazz, String name, Object[] args) {
        Method[] methods;
        Class[] argTypes = ReflectionUtils.createTypeArray(args);
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!m.getName().equals(name) || !ReflectionUtils.matchingTypes(argTypes, m.getParameterTypes())) continue;
            return m;
        }
        return null;
    }

    public static Constructor getMatchingConstructor(Class clazz, Object[] args) {
        Constructor<?>[] constructors;
        Class[] argTypes = ReflectionUtils.createTypeArray(args);
        for (Constructor<?> c : constructors = clazz.getDeclaredConstructors()) {
            if (!ReflectionUtils.matchingTypes(argTypes, c.getParameterTypes())) continue;
            return c;
        }
        return null;
    }

    public static boolean matchingTypes(Class<?>[] argTypes, Class<?>[] types) {
        if (argTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Class c;
            if (argTypes[i] == null) continue;
            Class clazz = c = types[i].isPrimitive() ? ReflectionUtils.mapPrimitveType(types[i]) : types[i];
            if (c.isAssignableFrom(argTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static Class mapPrimitveType(Class type) {
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        return type;
    }

    public static Class[] createTypeArray(Object[] args) {
        if (args == null || args.length == 0) {
            return new Class[0];
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i] != null ? args[i].getClass() : null;
        }
        return argTypes;
    }

    public static String getCurrentMethodName() {
        Exception e = new Exception();
        StackTraceElement[] elts = e.getStackTrace();
        if (elts.length < 2) {
            return "method name not found";
        }
        return elts[1].getMethodName();
    }
}

