/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jppf.JPPFException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionHelper {
    private static Logger log = LoggerFactory.getLogger(ReflectionHelper.class);
    private boolean debugEnabled = log.isDebugEnabled();

    public static Object invokeMethod(Class<?> clazz, Object instance, String methodName, Class<?>[] paramTypes, Object ... values) {
        try {
            Method m = clazz.getMethod(methodName, paramTypes);
            return m.invoke(instance, values);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object invokeMethod(Class<?> clazz, Object instance, String methodName, Object ... values) {
        try {
            Method[] methods;
            int nbArgs = values == null ? 0 : values.length;
            for (Method m : methods = clazz.getMethods()) {
                if (!m.getName().equals(methodName) || m.getParameterTypes().length != nbArgs) continue;
                return m.invoke(instance, values);
            }
            throw new NoSuchMethodException("class : " + clazz + ", method: " + methodName);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object invokeMethod(Class clazz, Object instance, String methodName) {
        return ReflectionHelper.invokeMethod(clazz, instance, methodName, null, (Object[])null);
    }

    public static Object newInstance(String className) {
        try {
            Class<?> c = ReflectionHelper.getCurrentClassLoader().loadClass(className);
            return c.newInstance();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object invokeConstructor(Class<?> clazz, Class<?>[] paramTypes, Object ... values) {
        try {
            Constructor<?> c = clazz.getConstructor(paramTypes);
            return c.newInstance(values);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Object getField(Class clazz, Object instance, String fieldName) {
        try {
            Field f = clazz.getField(fieldName);
            return f.get(instance);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new JPPFException((Throwable)e);
        }
    }

    public static Class[] getClasses(String ... classNames) {
        try {
            if (classNames == null || classNames.length <= 0) {
                return new Class[0];
            }
            Class[] classes = new Class[classNames.length];
            ClassLoader cl = ReflectionHelper.getCurrentClassLoader();
            for (int i = 0; i < classNames.length; ++i) {
                classes[i] = cl.loadClass(classNames[i]);
            }
            return classes;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Class getClass0(String className) {
        try {
            return ReflectionHelper.getCurrentClassLoader().loadClass(className);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ReflectionHelper.class.getClassLoader();
        }
        return cl;
    }
}

