/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jppf.io.DataLocation;
import org.jppf.serialization.JPPFObjectStreamFactory;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.streams.JPPFByteArrayOutputStream;

public class ObjectSerializerImpl
implements ObjectSerializer {
    public JPPFBuffer serialize(Object o) throws Exception {
        return this.serialize(o, false);
    }

    public JPPFBuffer serialize(Object o, boolean noCopy) throws Exception {
        JPPFByteArrayOutputStream baos = new JPPFByteArrayOutputStream();
        this.serialize(o, (OutputStream)baos);
        byte[] data = noCopy ? baos.getBuf() : baos.toByteArray();
        return new JPPFBuffer(data, baos.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object o, OutputStream os) throws Exception {
        ObjectOutputStream oos = JPPFObjectStreamFactory.newObjectOutputStream((OutputStream)os);
        try {
            oos.writeObject(o);
            oos.flush();
        }
        finally {
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(Object o, DataLocation location) throws Exception {
        ObjectOutputStream oos = JPPFObjectStreamFactory.newObjectOutputStream((OutputStream)location.getOutputStream());
        try {
            oos.writeObject(o);
            oos.flush();
        }
        finally {
            oos.close();
        }
    }

    public Object deserialize(JPPFBuffer buf) throws Exception {
        return this.deserialize(new ByteArrayInputStream(buf.getBuffer(), 0, buf.getLength()));
    }

    public Object deserialize(byte[] bytes) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes));
    }

    public Object deserialize(byte[] bytes, int offset, int length) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes, offset, length));
    }

    public Object deserialize(InputStream is) throws Exception {
        return this.deserialize(is, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(InputStream is, boolean closeStream) throws Exception {
        ObjectInputStream ois = JPPFObjectStreamFactory.newObjectInputStream((InputStream)is);
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            if (closeStream) {
                ois.close();
            }
        }
    }
}

