/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.task.storage;

import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.task.storage.MemoryMapDataProvider;
import org.jppf.utils.JPPFCallable;
import org.jppf.utils.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDataProvider
extends MemoryMapDataProvider {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ClientDataProvider.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public <V> Object computeValue(Object key, JPPFCallable<V> callable) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        Object result = null;
        if (callable != null) {
            result = ClientDataProvider.getValueFromClient(callable);
        }
        this.setValue(key, result == null ? SpecialValue.NULL_VALUE : result);
        return SpecialValue.NULL_VALUE.equals(result) ? null : result;
    }

    private static <V> Object getValueFromClient(JPPFCallable<V> callable) {
        ClassLoader cl = callable.getClass().getClassLoader();
        if (!(cl instanceof AbstractJPPFClassLoader)) {
            return null;
        }
        try {
            AbstractJPPFClassLoader loader = (AbstractJPPFClassLoader)cl;
            Class clazz = loader.loadClass("org.jppf.utils.ObjectSerializerImpl");
            ObjectSerializer ser = (ObjectSerializer)clazz.newInstance();
            byte[] bytes = ser.serialize(callable).getBuffer();
            bytes = loader.computeRemoteData(bytes);
            if (bytes == null) {
                return null;
            }
            return ser.deserialize(bytes);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    private static enum SpecialValue {
        NULL_VALUE;

    }
}

