/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.spi;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jppf.JPPFException;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.spi.JPPFBundlerProvider;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ServiceFinder;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFBundlerFactory {
    private static Logger log = LoggerFactory.getLogger(JPPFBundlerFactory.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    public static final String SERVER_DEFAULTS = "jppf.load.balancing.algorithm = proportional\n" + "jppf.load.balancing.strategy = jppf\n" + "strategy.jppf.performanceCacheSize = 3000\n" + "strategy.jppf.proportionalityFactor = 1\n" + "strategy.jppf.initialSize = 10\n" + "strategy.jppf.initialMeanTime = 1e9\n";
    public static final String CLIENT_DEFAULTS = "jppf.load.balancing.algorithm = manual\n" + "jppf.load.balancing.strategy = jppf\n" + "strategy.jppf.size = 1000000\n";
    private Map<String, JPPFBundlerProvider> providerMap = null;
    private final TypedProperties defaultConfig;

    public JPPFBundlerFactory() {
        this(SERVER_DEFAULTS);
    }

    public JPPFBundlerFactory(String def) {
        this.defaultConfig = StringUtils.toProperties((String)def);
        if (debugEnabled) {
            log.debug("using default properties: " + this.defaultConfig);
        }
    }

    public Bundler createBundler(String name, TypedProperties configuration) throws Exception {
        JPPFBundlerProvider provider = this.getBundlerProvider(name);
        if (provider == null) {
            throw new JPPFException("Provider '" + name + "' could not be found");
        }
        LoadBalancingProfile profile = provider.createProfile(configuration);
        return provider.createBundler(profile);
    }

    public Bundler createBundlerFromJPPFConfiguration() throws Exception {
        String profileName;
        TypedProperties props = JPPFConfiguration.getProperties();
        String algorithm = props.getString("jppf.load.balancing.algorithm", null);
        if (algorithm == null) {
            algorithm = props.getString("task.bundle.strategy", null);
        }
        if (algorithm == null) {
            algorithm = this.defaultConfig.getString("jppf.load.balancing.algorithm", "proportional");
        }
        if ((profileName = props.getString("jppf.load.balancing.strategy", null)) == null) {
            profileName = props.getString("task.bundle.autotuned.strategy", null);
        }
        if (profileName == null) {
            profileName = this.defaultConfig.getString("jppf.load.balancing.strategy", "jppf");
            for (Map.Entry entry : this.defaultConfig.entrySet()) {
                String key;
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || props.containsKey((Object)(key = (String)entry.getKey())) || !key.startsWith("strategy.jppf.")) continue;
                props.put((Object)key, entry.getValue());
            }
        }
        TypedProperties configuration = this.convertJPPFConfiguration(profileName, props);
        if (debugEnabled) {
            log.debug("load balancing configuration using algorithm '" + algorithm + "' with parameters: " + configuration);
        }
        return this.createBundler(algorithm, configuration);
    }

    public JPPFBundlerProvider getBundlerProvider(String name) throws Exception {
        if (this.providerMap == null) {
            this.loadProviders();
        }
        return this.providerMap.get(name);
    }

    public List<String> getBundlerProviderNames() throws Exception {
        if (this.providerMap == null) {
            this.loadProviders();
        }
        return new ArrayList<String>(this.providerMap.keySet());
    }

    private void loadProviders() throws Exception {
        Hashtable<String, JPPFBundlerProvider> map = new Hashtable<String, JPPFBundlerProvider>();
        Iterator it = ServiceFinder.lookupProviders(JPPFBundlerProvider.class);
        while (it.hasNext()) {
            JPPFBundlerProvider provider = (JPPFBundlerProvider)it.next();
            map.put(provider.getAlgorithmName(), provider);
            if (!debugEnabled) continue;
            log.debug("registering new load-balancing algorithm provider '" + provider.getAlgorithmName() + '\'');
        }
        if (debugEnabled) {
            log.debug("found " + map.size() + " load-balancing algorithms in the classpath");
        }
        this.providerMap = map;
    }

    public TypedProperties convertJPPFConfiguration(String profileName, TypedProperties configuration) {
        TypedProperties profile = this.extractJPPFConfiguration(profileName, configuration);
        String prefix = "strategy." + profileName + '.';
        TypedProperties result = new TypedProperties();
        for (Map.Entry entry : profile.entrySet()) {
            String key = (String)entry.getKey();
            String s = key.substring(prefix.length());
            result.setProperty(s, (String)entry.getValue());
        }
        return result;
    }

    public TypedProperties extractJPPFConfiguration(String profileName, TypedProperties configuration) {
        TypedProperties profile = new TypedProperties();
        String prefix = "strategy." + profileName + '.';
        Set entries = configuration.entrySet();
        for (Map.Entry entry : entries) {
            String key;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(key = (String)entry.getKey()).startsWith(prefix)) continue;
            profile.setProperty(key, (String)entry.getValue());
        }
        return profile;
    }
}

