/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.proportional;

import java.util.concurrent.atomic.AtomicReference;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.autotuned.AbstractAutoTuneProfile;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionalTuneProfile
extends AbstractAutoTuneProfile {
    private static Logger log = LoggerFactory.getLogger(ProportionalTuneProfile.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static AtomicReference<ProportionalTuneProfile> defaultProfile = new AtomicReference<ProportionalTuneProfile>(new ProportionalTuneProfile());
    private int performanceCacheSize = 2000;
    private int proportionalityFactor = 1;
    private int initialSize = 10;
    private double initialMeanTime = 1.0E9;
    private String name = "unknown";

    public ProportionalTuneProfile() {
        if (debugEnabled) {
            log.debug("in default constructor");
        }
    }

    public ProportionalTuneProfile(String profileName) {
        if (debugEnabled) {
            log.debug("in constructor with profile name");
        }
        this.name = profileName;
        String prefix = "strategy." + profileName + '.';
        TypedProperties props = JPPFConfiguration.getProperties();
        this.performanceCacheSize = props.getInt(prefix + "performanceCacheSize", 2000, 1, Integer.MAX_VALUE);
        this.proportionalityFactor = props.getInt(prefix + "proportionalityFactor", 1, 1, Integer.MAX_VALUE);
        this.initialSize = props.getInt(prefix + "initialSize", 10, 1, Integer.MAX_VALUE);
        this.initialMeanTime = props.getDouble(prefix + "initialMeanTime", 1.0E9, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public ProportionalTuneProfile(TypedProperties config) {
        if (debugEnabled) {
            log.debug("in constructor without profile name");
        }
        this.performanceCacheSize = config.getInt("performanceCacheSize", 2000);
        this.proportionalityFactor = config.getInt("proportionalityFactor", 1);
        this.initialSize = config.getInt("initialSize", 10);
        this.initialMeanTime = config.getDouble("initialMeanTime", 1.0E9, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    @Override
    public LoadBalancingProfile copy() {
        ProportionalTuneProfile other = new ProportionalTuneProfile();
        other.setPerformanceCacheSize(this.performanceCacheSize);
        other.setProportionalityFactor(this.proportionalityFactor);
        other.setInitialSize(this.initialSize);
        other.setInitialMeanTime(this.initialMeanTime);
        return other;
    }

    public int getPerformanceCacheSize() {
        return this.performanceCacheSize;
    }

    public void setPerformanceCacheSize(int performanceCacheSize) {
        this.performanceCacheSize = performanceCacheSize;
    }

    public int getProportionalityFactor() {
        return this.proportionalityFactor;
    }

    public void setProportionalityFactor(int proportionalityFactor) {
        this.proportionalityFactor = proportionalityFactor;
    }

    public static ProportionalTuneProfile getDefaultProfile() {
        return defaultProfile.get();
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public double getInitialMeanTime() {
        return this.initialMeanTime;
    }

    public void setInitialMeanTime(double initialMeanTime) {
        this.initialMeanTime = initialMeanTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("profileName=").append(this.name);
        sb.append(", performanceCacheSize=").append(this.performanceCacheSize);
        sb.append(", proportionalityFactor=").append(this.proportionalityFactor);
        sb.append(", initialSize=").append(this.initialSize);
        return sb.toString();
    }
}

