/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.proportional;

import java.util.HashSet;
import java.util.Set;
import org.jppf.server.scheduler.bundle.AbstractAdaptiveBundler;
import org.jppf.server.scheduler.bundle.BundleDataHolder;
import org.jppf.server.scheduler.bundle.BundlePerformanceSample;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.proportional.ProportionalTuneProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProportionalBundler
extends AbstractAdaptiveBundler {
    private static Logger log = LoggerFactory.getLogger(AbstractProportionalBundler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private static final Set<AbstractProportionalBundler> BUNDLERS = new HashSet<AbstractProportionalBundler>();
    private final Set<AbstractProportionalBundler> bundlers;
    protected final BundleDataHolder dataHolder;

    public AbstractProportionalBundler(LoadBalancingProfile profile) {
        this(profile, null);
    }

    protected AbstractProportionalBundler(LoadBalancingProfile profile, Set<AbstractProportionalBundler> bundlers) {
        super(profile);
        this.bundlers = bundlers == null ? BUNDLERS : bundlers;
        if (this.profile == null) {
            this.profile = new ProportionalTuneProfile();
        }
        ProportionalTuneProfile prof = (ProportionalTuneProfile)this.profile;
        this.dataHolder = new BundleDataHolder(prof.getPerformanceCacheSize(), prof.getInitialMeanTime());
        this.bundleSize = prof.getInitialSize();
        if (this.bundleSize < 1) {
            this.bundleSize = 1;
        }
        if (debugEnabled) {
            log.debug("Bundler#" + this.bundlerNumber + ": Using proportional bundle size - the initial size is " + this.bundleSize + ", profile: " + profile);
        }
    }

    protected final Set<AbstractProportionalBundler> getBundlers() {
        return this.bundlers;
    }

    public void setBundleSize(int size) {
        this.bundleSize = size <= 0 ? 1 : size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(int size, double time) {
        if (traceEnabled) {
            log.trace("Bundler#" + this.bundlerNumber + ": new performance sample [size=" + size + ", time=" + (long)time + ']');
        }
        if (size <= 0) {
            return;
        }
        BundlePerformanceSample sample = new BundlePerformanceSample(time / (double)size, size);
        Set<AbstractProportionalBundler> set = this.bundlers;
        synchronized (set) {
            this.dataHolder.addSample(sample);
            this.computeBundleSizes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup() {
        Set<AbstractProportionalBundler> set = this.bundlers;
        synchronized (set) {
            this.bundlers.add(this);
            if (debugEnabled) {
                log.debug("added " + this + ", bundlers set = " + this.bundlers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Set<AbstractProportionalBundler> set = this.bundlers;
        synchronized (set) {
            this.bundlers.remove(this);
            if (debugEnabled) {
                log.debug("removed " + this + ", bundlers set = " + this.bundlers);
            }
        }
    }

    public BundleDataHolder getDataHolder() {
        return this.dataHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeBundleSizes() {
        Set<AbstractProportionalBundler> set = this.bundlers;
        synchronized (set) {
            BundleDataHolder h;
            double maxMean = Double.NEGATIVE_INFINITY;
            double minMean = Double.POSITIVE_INFINITY;
            AbstractProportionalBundler minBundler = null;
            double meanSum = 0.0;
            for (AbstractProportionalBundler b : this.bundlers) {
                h = b.getDataHolder();
                double m = h.getMean();
                if (m > maxMean) {
                    maxMean = m;
                }
                if (!(m < minMean)) continue;
                minMean = m;
                minBundler = b;
            }
            for (AbstractProportionalBundler b : this.bundlers) {
                h = b.getDataHolder();
                meanSum += this.normalize(h.getMean());
            }
            int max = this.maxSize();
            int sum = 0;
            for (AbstractProportionalBundler b : this.bundlers) {
                BundleDataHolder h2 = b.getDataHolder();
                double p = this.normalize(h2.getMean()) / meanSum;
                int size = Math.max(1, (int)(p * (double)max));
                if (size >= max) {
                    size = max - 1;
                }
                b.setBundleSize(size);
                sum += size;
            }
            if (sum < max && minBundler != null) {
                int size = minBundler.getBundleSize();
                minBundler.setBundleSize(size + (max - sum));
            }
            if (traceEnabled) {
                StringBuilder sb = new StringBuilder();
                sb.append("bundler info:\n");
                sb.append("  minMean=").append(minMean).append(", maxMean=").append(maxMean).append(", maxSize=").append(max).append('\n');
                for (AbstractProportionalBundler b : this.bundlers) {
                    sb.append("  bundler #").append(b.getBundlerNumber()).append(" : bundleSize=").append(b.getBundleSize()).append(", ");
                    sb.append(b.getDataHolder()).append('\n');
                }
                log.trace(sb.toString());
            }
        }
    }

    public double normalize(double x) {
        double r = 1.0;
        for (int i = 0; i < ((ProportionalTuneProfile)this.profile).getProportionalityFactor(); ++i) {
            r *= x;
        }
        return 1.0 / r;
    }

    @Override
    public Bundler copy() {
        return null;
    }

    @Override
    protected int maxSize() {
        return 0;
    }
}

