/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.nodethreads;

import org.jppf.management.JPPFSystemInformation;
import org.jppf.server.scheduler.bundle.AbstractBundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.NodeAwareness;
import org.jppf.server.scheduler.bundle.nodethreads.NodeThreadsProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeThreadsLoadBalancer
extends AbstractBundler
implements NodeAwareness {
    private static Logger log = LoggerFactory.getLogger(AbstractNodeThreadsLoadBalancer.class);
    protected JPPFSystemInformation nodeConfiguration = null;
    protected int bundleSize = 1;

    public AbstractNodeThreadsLoadBalancer(LoadBalancingProfile profile) {
        super(profile);
    }

    @Override
    public int getBundleSize() {
        return this.bundleSize;
    }

    @Override
    public JPPFSystemInformation getNodeConfiguration() {
        return this.nodeConfiguration;
    }

    @Override
    public void setNodeConfiguration(JPPFSystemInformation nodeConfiguration) {
        this.nodeConfiguration = nodeConfiguration;
        this.computeBundleSize();
        if (log.isDebugEnabled()) {
            log.debug("setting node configuration on bundler #" + this.bundlerNumber + ": " + nodeConfiguration);
        }
    }

    private void computeBundleSize() {
        JPPFSystemInformation nodeConfig;
        if (log.isDebugEnabled()) {
            log.debug("computing bundle size for bundler #" + this.bundlerNumber);
        }
        if ((nodeConfig = this.getNodeConfiguration()) == null) {
            this.bundleSize = 1;
        } else {
            int multiplicator;
            int nbThreads = this.getNodeConfiguration().getJppf().getInt("processing.threads", -1);
            if (nbThreads <= 0) {
                nbThreads = this.getNodeConfiguration().getRuntime().getInt("availableProcessors");
            }
            if (nbThreads <= 0) {
                nbThreads = 1;
            }
            if ((multiplicator = ((NodeThreadsProfile)this.profile).getMultiplicator()) <= 0) {
                multiplicator = 1;
            }
            this.bundleSize = nbThreads * multiplicator;
        }
        if (log.isDebugEnabled()) {
            log.debug("bundler #" + this.bundlerNumber + " computed new bundle size = " + this.bundleSize);
        }
    }

    @Override
    public void dispose() {
        if (log.isDebugEnabled()) {
            log.debug("disposing bundler #" + this.bundlerNumber);
        }
        this.nodeConfiguration = null;
    }
}

