/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.impl;

import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.proportional.AbstractProportionalBundler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionalBundler
extends AbstractProportionalBundler {
    private static Logger log = LoggerFactory.getLogger(ProportionalBundler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();

    public ProportionalBundler(LoadBalancingProfile profile) {
        super(profile);
    }

    @Override
    public Bundler copy() {
        return new ProportionalBundler(this.profile);
    }

    @Override
    protected int maxSize() {
        if (traceEnabled) {
            log.trace("bundler #" + this.bundlerNumber + ": jppfContext=" + this.jppfContext);
        }
        if (this.jppfContext == null) {
            return 300;
        }
        int n = this.jppfContext.getMaxBundleSize();
        if (traceEnabled) {
            log.trace("bundler #" + this.bundlerNumber + ": maxBundleSize=" + n);
        }
        return n <= 0 ? 300 : n;
    }
}

