/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.impl;

import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.ContextAwareness;
import org.jppf.server.scheduler.bundle.JPPFContext;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.nodethreads.AbstractNodeThreadsLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeThreadsLoadBalancer
extends AbstractNodeThreadsLoadBalancer
implements ContextAwareness {
    private static Logger log = LoggerFactory.getLogger(NodeThreadsLoadBalancer.class);
    private JPPFContext jppfContext = null;

    public NodeThreadsLoadBalancer(LoadBalancingProfile profile) {
        super(profile);
        if (log.isDebugEnabled()) {
            log.debug("creating " + this.getClass().getSimpleName() + " #" + this.bundlerNumber);
        }
    }

    @Override
    public Bundler copy() {
        return new NodeThreadsLoadBalancer(this.profile.copy());
    }

    @Override
    protected int maxSize() {
        return this.jppfContext == null || this.jppfContext.getMaxBundleSize() <= 0 ? 300 : this.jppfContext.getMaxBundleSize();
    }

    @Override
    public JPPFContext getJPPFContext() {
        return this.jppfContext;
    }

    @Override
    public void setJPPFContext(JPPFContext context) {
        this.jppfContext = context;
    }
}

