/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.impl;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.proportional.AbstractProportionalBundler;
import org.jppf.server.scheduler.bundle.proportional.ProportionalTuneProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSimulator {
    private static Logger log = LoggerFactory.getLogger(NodeSimulator.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static int nbNodes = 1;
    private static ExecutorService threadPool = null;
    private double latency = 0.0;
    private double dynamicOverhead = 0.0;
    private double speed = 0.0;

    public NodeSimulator(double latency, double dynamicOverhead, double speed) {
        this.latency = latency;
        this.dynamicOverhead = dynamicOverhead;
        this.speed = speed;
        log.info("initializing with " + latency + ", " + dynamicOverhead + ", " + speed);
    }

    public void run(Bundler bundler, double sizeMB, int nbTasks, long timePerTask) {
        try {
            long start = System.nanoTime();
            long a = (long)this.latency;
            int b = (int)((this.latency - (double)a) * 1000000.0);
            Thread.sleep(a, b);
            Thread.sleep((long)(sizeMB * this.dynamicOverhead));
            for (int i = 0; i < nbTasks; ++i) {
                Thread.sleep((long)((double)timePerTask / this.speed));
            }
            long elapsed = System.nanoTime() - start;
            bundler.feedback(nbTasks, elapsed);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String ... args) {
        try {
            int i;
            ProportionalTuneProfile profile = new ProportionalTuneProfile();
            profile.setPerformanceCacheSize(2000);
            profile.setProportionalityFactor(2);
            nbNodes = 2;
            int maxTasks = 1000;
            double size = 16.0;
            double dataProviderSize = 8.0;
            long timePerTask = 5L;
            int nbIter = 20;
            SimulatedProportionalBundler initialBundler = new SimulatedProportionalBundler((LoadBalancingProfile)profile, maxTasks);
            System.out.println("Starting simulation with nbNodes=" + nbNodes + ", maxTasks=" + maxTasks + ", size=" + size + ", dataProviderSize=" + dataProviderSize + ", timePerTask=" + timePerTask + ", nbIter=" + nbIter);
            threadPool = Executors.newFixedThreadPool(nbNodes);
            Bundler[] bundlers = new Bundler[nbNodes];
            NodeSimulator[] nodes = new NodeSimulator[nbNodes];
            for (i = 0; i < nbNodes; ++i) {
                bundlers[i] = initialBundler.copy();
                bundlers[i].setup();
            }
            nodes[0] = new NodeSimulator(0.25, 0.5, 3.0);
            nodes[1] = new NodeSimulator(2.0, 10.0, 1.0);
            for (i = 0; i < nbIter; ++i) {
                long start = System.currentTimeMillis();
                int pending = maxTasks;
                while (pending > 0) {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    for (int j = 0; j < nbNodes; ++j) {
                        int n = bundlers[j].getBundleSize();
                        if (n > pending) {
                            n = pending;
                        }
                        list.add(n);
                        if ((pending -= n) <= 0) break;
                    }
                    if (debugEnabled) {
                        log.debug("Iteration #" + i + " : list = " + list);
                    }
                    ArrayList futures = new ArrayList();
                    for (int j = 0; j < list.size(); ++j) {
                        int n = (Integer)list.get(j);
                        double s = (double)n * (size - dataProviderSize) / (double)maxTasks;
                        futures.add(threadPool.submit(new SimulatorTask(bundlers[j], s, n, timePerTask, nodes[j])));
                    }
                    for (Future future : futures) {
                        future.get();
                    }
                }
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("Iteration #" + i + " performed in " + elapsed + " ms");
            }
            threadPool.shutdownNow();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class SimulatedProportionalBundler
    extends AbstractProportionalBundler {
        private int maximumSize = 300;

        public SimulatedProportionalBundler(LoadBalancingProfile profile, int maximumSize) {
            super(profile);
            this.maximumSize = maximumSize;
        }

        @Override
        protected int maxSize() {
            return this.maximumSize;
        }

        @Override
        public Bundler copy() {
            return new SimulatedProportionalBundler(this.profile, this.maximumSize);
        }
    }

    public static class SimulatorTask
    implements Runnable {
        private Bundler bundler = null;
        private double sizeMB = 0.0;
        private int nbTasks = 0;
        private long timePerTask = 0L;
        private NodeSimulator simulator = null;

        public SimulatorTask(Bundler bundler, double sizeMB, int nbTasks, long timePerTask, NodeSimulator simulator) {
            this.bundler = bundler;
            this.sizeMB = sizeMB;
            this.nbTasks = nbTasks;
            this.timePerTask = timePerTask;
            this.simulator = simulator;
        }

        @Override
        public void run() {
            this.simulator.run(this.bundler, this.sizeMB, this.nbTasks, this.timePerTask);
        }
    }
}

