/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.impl;

import java.util.concurrent.locks.ReentrantLock;
import org.jppf.server.scheduler.bundle.AbstractBundler;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.autotuned.AnnealingTuneProfile;
import org.jppf.server.scheduler.bundle.impl.AutoTunedBundler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutotunedDelegatingBundler
extends AbstractBundler {
    private static Logger log = LoggerFactory.getLogger(AutotunedDelegatingBundler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static AutoTunedBundler simpleBundler = null;
    private static ReentrantLock lock = new ReentrantLock();
    protected AnnealingTuneProfile profile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutotunedDelegatingBundler(AnnealingTuneProfile profile) {
        super(profile);
        log.info("Bundler#" + this.bundlerNumber + ": Using Auto-Tuned bundle size");
        lock.lock();
        try {
            Class<AutotunedDelegatingBundler> clazz = AutotunedDelegatingBundler.class;
            synchronized (AutotunedDelegatingBundler.class) {
                if (simpleBundler == null) {
                    simpleBundler = new AutoTunedBundler((LoadBalancingProfile)profile);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        finally {
            lock.unlock();
        }
        {
            return;
        }
    }

    @Override
    public Bundler copy() {
        return new AutotunedDelegatingBundler(this.profile);
    }

    @Override
    public int getBundleSize() {
        return simpleBundler.getBundleSize();
    }

    @Override
    public void feedback(int bundleSize, double totalTime) {
        simpleBundler.feedback(bundleSize, totalTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int maxSize() {
        int max = 0;
        AutoTunedBundler autoTunedBundler = simpleBundler;
        synchronized (autoTunedBundler) {
            max = simpleBundler.maxSize();
        }
        return max;
    }
}

