/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.impl;

import java.util.Map;
import org.jppf.server.scheduler.bundle.BundlePerformanceSample;
import org.jppf.server.scheduler.bundle.Bundler;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.autotuned.AnnealingTuneProfile;
import org.jppf.server.scheduler.bundle.impl.AbstractAutoTunedBundler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTunedBundler
extends AbstractAutoTunedBundler {
    private static Logger log = LoggerFactory.getLogger(AutoTunedBundler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();

    public AutoTunedBundler(LoadBalancingProfile profile) {
        super((AnnealingTuneProfile)profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(int bundleSize, double time) {
        BundlePerformanceSample bundleSample;
        assert (bundleSize > 0);
        if (traceEnabled) {
            log.trace("Bundler#" + this.bundlerNumber + ": Got another sample with bundleSize=" + bundleSize + " and totalTime=" + time);
        }
        Map map = this.samplesMap;
        synchronized (map) {
            bundleSample = (BundlePerformanceSample)this.samplesMap.get(bundleSize);
            if (bundleSample == null) {
                bundleSample = new BundlePerformanceSample();
                this.samplesMap.put(bundleSize, bundleSample);
            }
        }
        long samples = bundleSample.samples + (long)bundleSize;
        BundlePerformanceSample bundlePerformanceSample = bundleSample;
        synchronized (bundlePerformanceSample) {
            bundleSample.mean = (time + (double)bundleSample.samples * bundleSample.mean) / (double)samples;
            bundleSample.samples = samples;
        }
        if (samples > ((AnnealingTuneProfile)this.profile).getMinSamplesToAnalyse()) {
            this.performAnalysis();
            if (traceEnabled) {
                log.trace("Bundler#" + this.bundlerNumber + ": bundle size = " + bundleSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAnalysis() {
        double stableMean = 0.0;
        Map map = this.samplesMap;
        synchronized (map) {
            int bestSize = this.searchBestSize();
            int max = this.maxSize();
            if (max > 0 && bestSize > max) {
                bestSize = max;
            }
            for (int counter = 0; counter < ((AnnealingTuneProfile)this.profile).getMaxGuessToStable(); ++counter) {
                int diff = ((AnnealingTuneProfile)this.profile).createDiff(bestSize, this.samplesMap.size(), this.rnd);
                if (diff < bestSize && this.rnd.nextBoolean()) {
                    diff = -diff;
                }
                this.bundleSize = bestSize + diff;
                if (this.samplesMap.get(this.bundleSize) != null) continue;
                if (traceEnabled) {
                    log.trace("Bundler#" + this.bundlerNumber + ": The next bundle size that will be used is " + this.bundleSize);
                }
                return;
            }
            this.bundleSize = Math.max(1, bestSize);
            BundlePerformanceSample sample = (BundlePerformanceSample)this.samplesMap.get(this.bundleSize);
            if (sample != null) {
                stableMean = sample.mean;
                this.samplesMap.clear();
                this.samplesMap.put(this.bundleSize, sample);
            }
        }
        if (traceEnabled) {
            log.trace("Bundler#" + this.bundlerNumber + ": The bundle size converged to " + this.bundleSize + " with the mean execution of " + stableMean);
        }
    }

    private int searchBestSize() {
        int bestSize = 0;
        double minorMean = Double.POSITIVE_INFINITY;
        for (Integer size : this.samplesMap.keySet()) {
            BundlePerformanceSample sample = (BundlePerformanceSample)this.samplesMap.get(size);
            if (!(sample.mean < minorMean)) continue;
            bestSize = size;
            minorMean = sample.mean;
        }
        if (traceEnabled) {
            log.trace("Bundler#" + this.bundlerNumber + ": best size found = " + bestSize);
        }
        return bestSize;
    }

    @Override
    public Bundler copy() {
        return new AutoTunedBundler(this.profile.copy());
    }

    @Override
    protected int maxSize() {
        if (this.jppfContext == null) {
            throw new IllegalStateException("jppfContext not set");
        }
        return this.jppfContext.getMaxBundleSize() / 2;
    }
}

