/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jppf.server.scheduler.bundle.AbstractAdaptiveBundler;
import org.jppf.server.scheduler.bundle.BundlePerformanceSample;
import org.jppf.server.scheduler.bundle.autotuned.AnnealingTuneProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutoTunedBundler
extends AbstractAdaptiveBundler {
    private static Logger log = LoggerFactory.getLogger(AbstractAutoTunedBundler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected Random rnd = new Random(System.currentTimeMillis());
    protected final Map<Integer, BundlePerformanceSample> samplesMap = new HashMap<Integer, BundlePerformanceSample>();

    public AbstractAutoTunedBundler(AnnealingTuneProfile profile) {
        super(profile);
        log.info("Bundler#" + this.bundlerNumber + ": Using Auto-Tuned bundle size");
        if (this.bundleSize < 1) {
            this.bundleSize = 1;
        }
        log.info("Bundler#" + this.bundlerNumber + ": The initial size is " + this.bundleSize);
    }

    @Override
    public int getBundleSize() {
        return this.bundleSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(int bundleSize, double time) {
        BundlePerformanceSample bundleSample;
        assert (bundleSize > 0);
        if (debugEnabled) {
            log.debug("Bundler#" + this.bundlerNumber + ": Got another sample with bundleSize=" + bundleSize + " and totalTime=" + time);
        }
        Map<Integer, BundlePerformanceSample> map = this.samplesMap;
        synchronized (map) {
            bundleSample = this.samplesMap.get(bundleSize);
            if (bundleSample == null) {
                bundleSample = new BundlePerformanceSample();
                this.samplesMap.put(bundleSize, bundleSample);
            }
        }
        long samples = bundleSample.samples + (long)bundleSize;
        BundlePerformanceSample bundlePerformanceSample = bundleSample;
        synchronized (bundlePerformanceSample) {
            bundleSample.mean = (time + (double)bundleSample.samples * bundleSample.mean) / (double)samples;
            bundleSample.samples = samples;
        }
        if (samples > ((AnnealingTuneProfile)this.profile).getMinSamplesToAnalyse()) {
            this.performAnalysis();
            if (debugEnabled) {
                log.debug("Bundler#" + this.bundlerNumber + ": bundle size = " + bundleSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAnalysis() {
        double stableMean = 0.0;
        Map<Integer, BundlePerformanceSample> map = this.samplesMap;
        synchronized (map) {
            int bestSize = this.searchBestSize();
            int max = this.maxSize();
            if (max > 0 && bestSize > max) {
                bestSize = max;
            }
            for (int counter = 0; counter < ((AnnealingTuneProfile)this.profile).getMaxGuessToStable(); ++counter) {
                int diff = ((AnnealingTuneProfile)this.profile).createDiff(bestSize, this.samplesMap.size(), this.rnd);
                if (diff < bestSize && this.rnd.nextBoolean()) {
                    diff = -diff;
                }
                this.bundleSize = bestSize + diff;
                if (this.samplesMap.get(this.bundleSize) != null) continue;
                if (debugEnabled) {
                    log.debug("Bundler#" + this.bundlerNumber + ": The next bundle size that will be used is " + this.bundleSize);
                }
                return;
            }
            this.bundleSize = Math.max(1, bestSize);
            BundlePerformanceSample sample = this.samplesMap.get(this.bundleSize);
            if (sample != null) {
                stableMean = sample.mean;
                this.samplesMap.clear();
                this.samplesMap.put(this.bundleSize, sample);
            }
        }
        log.info("Bundler#" + this.bundlerNumber + ": The bundle size converged to " + this.bundleSize + " with the mean execution of " + stableMean);
    }

    private int searchBestSize() {
        int bestSize = 0;
        double minorMean = Double.POSITIVE_INFINITY;
        for (Integer size : this.samplesMap.keySet()) {
            BundlePerformanceSample sample = this.samplesMap.get(size);
            if (!(sample.mean < minorMean)) continue;
            bestSize = size;
            minorMean = sample.mean;
        }
        if (debugEnabled) {
            log.debug("Bundler#" + this.bundlerNumber + ": best size found = " + bestSize);
        }
        return bestSize;
    }
}

