/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle;

import org.jppf.management.JPPFSystemInformation;
import org.jppf.server.scheduler.bundle.AbstractBundler;
import org.jppf.server.scheduler.bundle.BundlerEx;
import org.jppf.server.scheduler.bundle.ContextAwareness;
import org.jppf.server.scheduler.bundle.JPPFContext;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.NodeAwareness;

public abstract class AbstractAdaptiveBundler
extends AbstractBundler
implements BundlerEx,
NodeAwareness,
ContextAwareness {
    protected int bundleSize = 1;
    protected JPPFSystemInformation nodeConfiguration = null;
    protected int nbThreads = 1;
    protected JPPFContext jppfContext = null;

    public AbstractAdaptiveBundler(LoadBalancingProfile profile) {
        super(profile);
    }

    @Override
    public int getBundleSize() {
        return this.bundleSize;
    }

    @Override
    public JPPFSystemInformation getNodeConfiguration() {
        return this.nodeConfiguration;
    }

    @Override
    public void setNodeConfiguration(JPPFSystemInformation nodeConfiguration) {
        this.nodeConfiguration = nodeConfiguration;
        this.nbThreads = nodeConfiguration.getJppf().getInt("processing.threads", 1);
    }

    @Override
    public void feedback(int size, double totalTime, double accumulatedElapsed, double overheadTime) {
        int n1 = size / this.nbThreads;
        int n2 = size % this.nbThreads;
        double mean = accumulatedElapsed / (double)size;
        double t = 0.0;
        if (n1 == 0) {
            t = mean;
        } else {
            t = (double)n1 * mean;
            if (n2 > 0) {
                t += mean * ((double)n2 / (double)this.nbThreads);
            }
        }
        this.feedback(size, t += overheadTime);
    }

    @Override
    public JPPFContext getJPPFContext() {
        return this.jppfContext;
    }

    @Override
    public void setJPPFContext(JPPFContext context) {
        this.jppfContext = context;
    }
}

