/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.jppf.execute.ExecutorChannel;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.protocol.utils.ServerJobStatus;
import org.jppf.server.submission.SubmissionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerJob {
    private static final Logger log = LoggerFactory.getLogger(ServerJob.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private volatile ServerJobStatus status = ServerJobStatus.NEW;
    private final List<Runnable> onDoneList = new ArrayList<Runnable>();
    private long jobReceivedTime = 0L;
    private transient long queueEntryTime = 0L;
    protected final JPPFTaskBundle job;
    private String uuid = null;
    private String name = null;
    private JobSLA sla = null;
    private JobMetadata metadata = null;
    private boolean jobExpired = false;
    private boolean pending = false;
    protected final Lock lock;
    private SubmissionStatus submissionStatus;
    protected ServerJobChangeListener notificationEmitter;
    protected List<ServerTaskBundleClient> completionBundles = null;

    protected AbstractServerJob(Lock lock, JPPFTaskBundle job) {
        if (lock == null) {
            throw new IllegalArgumentException("lock is null");
        }
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (debugEnabled) {
            log.debug("creating ClientJob #" + INSTANCE_COUNT.incrementAndGet());
        }
        this.lock = lock;
        this.job = job;
        this.uuid = this.job.getUuid();
        this.name = this.job.getName();
        this.sla = this.job.getSLA();
        this.metadata = this.job.getMetadata();
        this.submissionStatus = SubmissionStatus.SUBMITTED;
    }

    public JPPFTaskBundle getJob() {
        return this.job;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobSLA getSLA() {
        return this.sla;
    }

    public JobMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(JobMetadata metadata) {
        this.metadata = metadata;
    }

    public void setSLA(JobSLA sla) {
        this.sla = sla;
    }

    public boolean isJobExpired() {
        return this.jobExpired;
    }

    public void jobExpired() {
        this.setJobExpired(true);
    }

    public void setJobExpired(boolean jobExpired) {
        this.jobExpired = jobExpired;
        if (this.jobExpired && !this.isDone()) {
            this.cancel(true);
        }
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setPending(boolean pending) {
        boolean oldValue = this.isPending();
        this.pending = pending;
        boolean newValue = this.isPending();
        if (oldValue != newValue) {
            this.fireJobUpdated();
        }
    }

    public boolean isSuspended() {
        return this.getJob().getSLA().isSuspended();
    }

    public void setSuspended(boolean suspended, boolean requeue) {
        JobSLA sla = this.getJob().getSLA();
        if (sla.isSuspended() == suspended) {
            return;
        }
        sla.setSuspended(suspended);
        this.fireJobUpdated();
    }

    public void setMaxNodes(int maxNodes) {
        if (maxNodes <= 0) {
            return;
        }
        this.getJob().getSLA().setMaxNodes(maxNodes);
        this.fireJobUpdated();
    }

    protected final boolean updateStatus(ServerJobStatus expect, ServerJobStatus newStatus) {
        if (this.status == expect) {
            this.status = newStatus;
            return true;
        }
        return false;
    }

    public boolean isDone() {
        return this.status.compareTo(ServerJobStatus.EXECUTING) >= 0;
    }

    public boolean isCancelled() {
        return this.status.compareTo(ServerJobStatus.CANCELLED) >= 0;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.status.compareTo(ServerJobStatus.EXECUTING) > 0) {
            return false;
        }
        this.status = ServerJobStatus.CANCELLED;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void done() {
        Runnable[] runnables;
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            runnables = this.onDoneList.toArray(new Runnable[this.onDoneList.size()]);
        }
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOnDone(Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is null");
        }
        List<Runnable> list = this.onDoneList;
        synchronized (list) {
            this.onDoneList.remove(runnable);
        }
    }

    public long getJobReceivedTime() {
        return this.jobReceivedTime;
    }

    public void setJobReceivedTime(long jobReceivedTime) {
        this.jobReceivedTime = jobReceivedTime;
    }

    public long getQueueEntryTime() {
        return this.queueEntryTime;
    }

    public void setQueueEntryTime(long queueEntryTime) {
        this.queueEntryTime = queueEntryTime;
    }

    public abstract int getTaskCount();

    public int getInitialTaskCount() {
        return this.job.getInitialTaskCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmissionStatus getSubmissionStatus() {
        this.lock.lock();
        try {
            SubmissionStatus submissionStatus = this.submissionStatus;
            return submissionStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubmissionStatus(SubmissionStatus submissionStatus) {
        this.lock.lock();
        try {
            if (this.submissionStatus == submissionStatus) {
                return;
            }
            SubmissionStatus oldValue = this.submissionStatus;
            this.submissionStatus = submissionStatus;
            this.fireStatusChanged(oldValue, this.submissionStatus);
            if (submissionStatus == SubmissionStatus.ENDED) {
                this.done();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void fireStatusChanged(SubmissionStatus oldValue, SubmissionStatus newValue) {
        if (this.notificationEmitter != null) {
            this.notificationEmitter.jobStatusChanged(this, oldValue, newValue);
        }
    }

    public String getBroadcastUUID() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerTaskBundleClient> getCompletionBundles() {
        this.lock.lock();
        try {
            if (this.completionBundles == null) {
                List<ServerTaskBundleClient> list = Collections.emptyList();
                return list;
            }
            List<ServerTaskBundleClient> list = this.completionBundles;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void fireJobUpdated() {
        if (this.notificationEmitter != null) {
            this.notificationEmitter.jobUpdated(this);
        }
    }

    protected void fireJobDispatched(ExecutorChannel channel, ServerTaskBundleNode bundleNode) {
        if (this.notificationEmitter != null) {
            this.notificationEmitter.jobDispatched(this, channel, bundleNode);
        }
    }

    protected void fireJobReturned(ExecutorChannel channel, ServerTaskBundleNode bundleNode) {
        if (this.notificationEmitter != null) {
            this.notificationEmitter.jobReturned(this, channel, bundleNode);
        }
    }
}

