/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol.results;

import java.util.HashMap;
import java.util.Map;
import org.jppf.server.protocol.results.SendResultsStrategy;

public class SendResultsStrategyManager {
    private static Map<String, SendResultsStrategy> strategyMap = SendResultsStrategyManager.initializeMap();
    private static final SendResultsStrategy DEFAULT_STRATEGY = strategyMap.get("NodeResults");

    private static Map<String, SendResultsStrategy> initializeMap() {
        HashMap<String, SendResultsStrategy> map = new HashMap<String, SendResultsStrategy>();
        map.put("AllResults", new SendResultsStrategy.SendAllResultsStrategy());
        map.put("NodeResults", new SendResultsStrategy.SendNodeResultsStrategy());
        return map;
    }

    public static SendResultsStrategy getStrategy(String name) {
        if (name == null) {
            return DEFAULT_STRATEGY;
        }
        SendResultsStrategy strategy = strategyMap.get(name);
        return strategy != null ? strategy : DEFAULT_STRATEGY;
    }
}

