/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jppf.execute.ExecutorChannel;
import org.jppf.io.DataLocation;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerTask;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTaskBundleNode
extends JPPFTaskBundle {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ServerTaskBundleNode.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final ServerJob job;
    private final transient DataLocation dataProvider;
    private final transient List<ServerTask> taskList;
    private boolean requeued = false;
    private boolean cancelled = false;
    private JPPFTaskBundle taskBundle;
    private ExecutorChannel channel = null;
    private Future<?> future = null;

    public ServerTaskBundleNode(ServerJob job, JPPFTaskBundle taskBundle, List<ServerTask> taskList) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (taskBundle == null) {
            throw new IllegalArgumentException("taskBundle is null");
        }
        if (taskList == null) {
            throw new IllegalArgumentException("taskList is null");
        }
        this.job = job;
        this.taskBundle = taskBundle;
        this.taskBundle.setCurrentTaskCount(taskList.size());
        this.setSLA(job.getSLA());
        this.setMetadata(job.getJob().getMetadata());
        this.taskList = Collections.unmodifiableList(new ArrayList<ServerTask>(taskList));
        this.setName(job.getJob().getName());
        this.dataProvider = job.getDataProvider();
        this.setTaskCount(this.taskList.size());
    }

    public JPPFTaskBundle getJob() {
        return this.taskBundle;
    }

    public ServerJob getClientJob() {
        return this.job;
    }

    public DataLocation getDataProviderL() {
        return this.dataProvider;
    }

    public List<ServerTask> getTaskList() {
        return this.taskList;
    }

    @Override
    public ServerTaskBundleNode copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ServerTaskBundleNode copy(int nbTasks) {
        throw new UnsupportedOperationException();
    }

    public void jobDispatched(ExecutorChannel channel, Future<?> future) {
        if (channel == null) {
            throw new IllegalArgumentException("channel is null");
        }
        if (future == null) {
            throw new IllegalArgumentException("future is null");
        }
        this.channel = channel;
        this.future = future;
        this.job.jobDispatched(this);
    }

    public void resultsReceived(List<DataLocation> results) {
        this.job.resultsReceived(this, results);
    }

    public void resultsReceived(Throwable throwable) {
        this.job.resultsReceived(this, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskCompleted(Exception exception) {
        if (debugEnabled && exception != null) {
            log.debug("received exception for " + this + " : " + ExceptionUtils.getStackTrace((Throwable)exception));
        }
        try {
            this.job.jobReturned(this);
        }
        finally {
            if (!this.isCancelled()) {
                this.job.taskCompleted(this, exception);
            }
            this.channel = null;
            this.future = null;
        }
    }

    public synchronized void resubmit() {
        if (this.getSLA().isBroadcastJob()) {
            return;
        }
        this.requeued = true;
    }

    public synchronized boolean isRequeued() {
        return this.requeued;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public ExecutorChannel getChannel() {
        return this.channel;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    @Override
    public String toString() {
        return ReflectionUtils.dumpObject((Object)this, "name", "uuid", "initialTaskCount", "taskCount", "requeued", "cancelled");
    }
}

