/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jppf.io.DataLocation;
import org.jppf.node.protocol.JobSLA;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.TaskState;
import org.jppf.server.protocol.results.SendResultsStrategy;
import org.jppf.server.protocol.results.SendResultsStrategyManager;
import org.jppf.utils.Pair;
import org.jppf.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTaskBundleClient {
    private static final Logger log = LoggerFactory.getLogger(ServerTaskBundleClient.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final JPPFTaskBundle job;
    private final DataLocation dataProvider;
    private final List<ServerTask> taskList = new LinkedList<ServerTask>();
    private final List<ServerTask> tasksToSendList = new LinkedList<ServerTask>();
    private final AtomicInteger pendingTasksCount = new AtomicInteger();
    private final List<CompletionListener> listenerList = new ArrayList<CompletionListener>();
    private CompletionListener[] listenerArray = null;
    private boolean cancelled = false;
    private boolean done = false;
    private long jobReceivedTime = 0L;
    final SendResultsStrategy strategy;

    public ServerTaskBundleClient(JPPFTaskBundle job, DataLocation dataProvider) {
        this(job, dataProvider, Collections.emptyList());
    }

    public ServerTaskBundleClient(JPPFTaskBundle job, DataLocation dataProvider, List<DataLocation> taskList) {
        if (job == null) {
            throw new IllegalArgumentException("job is null");
        }
        if (taskList == null) {
            throw new IllegalArgumentException("taskList is null");
        }
        this.job = job;
        this.dataProvider = dataProvider;
        for (int index = 0; index < taskList.size(); ++index) {
            DataLocation dataLocation = taskList.get(index);
            this.taskList.add(new ServerTask(this, index, dataLocation));
        }
        this.pendingTasksCount.set(this.taskList.size());
        this.strategy = SendResultsStrategyManager.getStrategy(job.getSLA().getResultsStrategy());
    }

    private ServerTaskBundleClient(ServerTaskBundleClient source, List<ServerTask> taskList) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (taskList == null) {
            throw new IllegalArgumentException("taskList is null");
        }
        this.job = source.getJob().copy(taskList.size());
        this.job.initialTaskCount = source.getJob().getInitialTaskCount();
        this.job.currentTaskCount = this.job.taskCount;
        this.dataProvider = source.getDataProvider();
        this.taskList.addAll(taskList);
        this.pendingTasksCount.set(0);
        this.done = source.isDone();
        this.cancelled = source.isCancelled();
        this.strategy = source.strategy;
    }

    public JPPFTaskBundle getJob() {
        return this.job;
    }

    public DataLocation getDataProvider() {
        return this.dataProvider;
    }

    public List<ServerTask> getTaskList() {
        return this.taskList;
    }

    public synchronized void resultReceived(Collection<Pair<Integer, DataLocation>> results) {
        if (this.isCancelled()) {
            return;
        }
        if (debugEnabled) {
            log.debug("*** received " + results.size() + " tasks for " + this);
        }
        ArrayList<ServerTask> tasks = new ArrayList<ServerTask>(results.size());
        for (Pair<Integer, DataLocation> result : results) {
            ServerTask task = this.taskList.get((Integer)result.first());
            if (task.getState() == TaskState.PENDING) {
                this.tasksToSendList.add(task);
                this.pendingTasksCount.decrementAndGet();
            }
            task.resultReceived((DataLocation)result.second());
        }
        this.done = this.pendingTasksCount.get() <= 0;
        boolean fire = this.strategy.sendResults(this, tasks);
        if (this.done || fire) {
            this.fireTasksCompleted();
        }
    }

    public synchronized void resultReceived(Collection<ServerTask> tasks, Throwable exception) {
        if (this.isCancelled()) {
            return;
        }
        for (ServerTask task : tasks) {
            if (task.getState() == TaskState.PENDING) {
                this.tasksToSendList.add(task);
                this.pendingTasksCount.decrementAndGet();
            }
            task.resultReceived(exception);
        }
        this.done = this.pendingTasksCount.get() <= 0;
        boolean fire = this.strategy.sendResults(this, tasks);
        if (this.done || fire) {
            this.fireTasksCompleted();
        }
    }

    public long getJobReceivedTime() {
        return this.jobReceivedTime;
    }

    public void setJobReceivedTime(long jobReceivedTime) {
        this.jobReceivedTime = jobReceivedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ServerTaskBundleClient serverTaskBundleClient = this;
        synchronized (serverTaskBundleClient) {
            if (!this.cancelled && !this.done) {
                if (debugEnabled) {
                    log.debug("cancelling client job " + this);
                }
                this.cancelled = true;
                for (ServerTask task : this.taskList) {
                    if (task.getState() != TaskState.PENDING) continue;
                    task.cancel();
                    this.tasksToSendList.add(task);
                    this.pendingTasksCount.decrementAndGet();
                }
                this.done = true;
            }
        }
        this.fireTasksCompleted();
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public List<DataLocation> getDataLocationList() {
        ArrayList<DataLocation> list = new ArrayList<DataLocation>(this.taskList.size());
        for (ServerTask task : this.taskList) {
            list.add(task.getDataLocation());
        }
        return list;
    }

    public JobSLA getSLA() {
        return this.job.getSLA();
    }

    public String getUuid() {
        return this.job.getUuid();
    }

    public int getTaskCount() {
        return this.taskList.size();
    }

    public int getPendingTasksCount() {
        return this.pendingTasksCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTasksCompleted(List<ServerTask> results) {
        CompletionListener[] listeners;
        if (results == null) {
            throw new IllegalArgumentException("results is null");
        }
        List<CompletionListener> list = this.listenerList;
        synchronized (list) {
            listeners = this.listenerArray;
        }
        ServerTaskBundleClient bundle = new ServerTaskBundleClient(this, results);
        for (CompletionListener listener : listeners) {
            listener.taskCompleted(bundle, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTasksCompleted() {
        CompletionListener[] listeners;
        ArrayList<ServerTask> completedTasks = new ArrayList<ServerTask>(this.tasksToSendList);
        this.tasksToSendList.clear();
        List<CompletionListener> list = this.listenerList;
        synchronized (list) {
            listeners = this.listenerArray;
        }
        ServerTaskBundleClient bundle = new ServerTaskBundleClient(this, completedTasks);
        for (CompletionListener listener : listeners) {
            listener.taskCompleted(bundle, completedTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleEnded() {
        CompletionListener[] listeners;
        if (this.dataProvider == null) {
            throw new IllegalArgumentException("dataProvider is null");
        }
        List<CompletionListener> list = this.listenerList;
        synchronized (list) {
            listeners = this.listenerArray;
        }
        for (CompletionListener listener : listeners) {
            listener.bundleEnded(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(CompletionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List<CompletionListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(listener);
            this.listenerArray = this.listenerList.toArray(new CompletionListener[this.listenerList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletionListener(CompletionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        List<CompletionListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(listener);
            this.listenerArray = this.listenerList.toArray(new CompletionListener[this.listenerList.size()]);
        }
    }

    public String toString() {
        return ReflectionUtils.dumpObject((Object)this, "pendingTasksCount", "cancelled", "done", "job");
    }

    public static interface CompletionListener {
        public void taskCompleted(ServerTaskBundleClient var1, List<ServerTask> var2);

        public void bundleEnded(ServerTaskBundleClient var1);
    }
}

