/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import org.jppf.io.DataLocation;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.TaskState;

public class ServerTask {
    private final ServerTaskBundleClient bundle;
    private final int position;
    private final DataLocation dataLocation;
    private DataLocation result = null;
    private Throwable exception;
    private TaskState state = TaskState.PENDING;

    public ServerTask(ServerTaskBundleClient bundle, int position, DataLocation dataLocation) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        if (dataLocation == null) {
            throw new IllegalArgumentException("dataLocation is null");
        }
        this.position = position;
        this.bundle = bundle;
        this.dataLocation = dataLocation;
    }

    public int getPosition() {
        return this.position;
    }

    public ServerTaskBundleClient getBundle() {
        return this.bundle;
    }

    public DataLocation getDataLocation() {
        return this.dataLocation;
    }

    public TaskState getState() {
        return this.state;
    }

    public DataLocation getResult() {
        return this.result == null ? this.dataLocation : this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void cancel() {
        this.result = this.dataLocation;
        this.state = TaskState.CANCELLED;
    }

    public void resultReceived(DataLocation result) {
        if (result == null) {
            throw new IllegalArgumentException("result is null");
        }
        this.result = result;
        this.exception = null;
        this.state = result == this.dataLocation ? TaskState.CANCELLED : TaskState.RESULT;
    }

    public void resultReceived(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception is null");
        }
        this.result = null;
        this.exception = exception;
        this.state = TaskState.EXCEPTION;
    }

    public void taskSent() {
        this.state = TaskState.SENT;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ServerTask");
        sb.append("{position=").append(this.position);
        sb.append(", state=").append((Object)this.getState());
        sb.append(", dataLocation=").append(this.dataLocation);
        sb.append(", result=").append(this.result);
        sb.append(", exception=").append(this.exception);
        sb.append('}');
        return sb.toString();
    }
}

