/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.jppf.io.DataLocation;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.protocol.utils.ServerJobStatus;
import org.jppf.server.submission.SubmissionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJobBroadcast
extends ServerJob {
    private static final Logger log = LoggerFactory.getLogger(ServerJobBroadcast.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private transient ServerJobBroadcast parentJob;
    private transient String broadcastUUID = null;
    private final Map<String, ServerJobBroadcast> broadcastMap;
    private final Set<ServerJobBroadcast> broadcastSet = new LinkedHashSet<ServerJobBroadcast>();

    public ServerJobBroadcast(Lock lock, ServerJobChangeListener notificationEmitter, JPPFTaskBundle job, DataLocation dataProvider) {
        this(lock, notificationEmitter, job, dataProvider, null, null);
    }

    protected ServerJobBroadcast(Lock lock, ServerJobChangeListener notificationEmitter, JPPFTaskBundle job, DataLocation dataProvider, ServerJobBroadcast parentJob, String broadcastUUID) {
        super(lock, notificationEmitter, job, dataProvider);
        if (!job.getSLA().isBroadcastJob()) {
            throw new IllegalStateException("Not broadcast job");
        }
        this.parentJob = parentJob;
        this.broadcastUUID = broadcastUUID;
        this.broadcastMap = broadcastUUID == null ? new LinkedHashMap<String, ServerJobBroadcast>() : Collections.emptyMap();
    }

    @Override
    public String getBroadcastUUID() {
        return this.broadcastUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerJobBroadcast createBroadcastJob(String broadcastUUID) {
        ServerJobBroadcast clientJob;
        if (broadcastUUID == null || broadcastUUID.isEmpty()) {
            throw new IllegalArgumentException("broadcastUUID is blank");
        }
        this.lock.lock();
        try {
            clientJob = new ServerJobBroadcast(this.lock, this.notificationEmitter, this.job, this.getDataProvider(), this, broadcastUUID);
            for (ServerTaskBundleClient bundle : this.getBundleList()) {
                clientJob.addBundle(bundle);
            }
            this.broadcastSet.add(clientJob);
        }
        finally {
            this.lock.unlock();
        }
        return clientJob;
    }

    @Override
    public void jobDispatched(ServerTaskBundleNode bundle) {
        super.jobDispatched(bundle);
        if (this.parentJob != null) {
            this.parentJob.broadcastDispatched(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastDispatched(ServerJobBroadcast broadcastJob) {
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        this.lock.lock();
        try {
            this.broadcastSet.remove(broadcastJob);
            boolean empty = this.broadcastMap.isEmpty();
            this.broadcastMap.put(broadcastJob.getBroadcastUUID(), broadcastJob);
            if (empty) {
                this.updateStatus(ServerJobStatus.NEW, ServerJobStatus.EXECUTING);
                this.setSubmissionStatus(SubmissionStatus.EXECUTING);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastCompleted(ServerJobBroadcast broadcastJob) {
        if (broadcastJob == null) {
            throw new IllegalArgumentException("broadcastJob is null");
        }
        this.lock.lock();
        try {
            if (this.broadcastMap.remove(broadcastJob.getBroadcastUUID()) != broadcastJob && !this.broadcastSet.contains(broadcastJob)) {
                throw new IllegalStateException("broadcast job not found");
            }
            if (this.broadcastMap.isEmpty()) {
                this.taskCompleted(null, null);
                this.setSubmissionStatus(SubmissionStatus.ENDED);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void fireTaskCompleted(ServerJob result) {
        if (this.parentJob == null) {
            super.fireTaskCompleted(result);
        } else {
            this.setSubmissionStatus(SubmissionStatus.ENDED);
            this.parentJob.broadcastCompleted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskCompleted(ServerTaskBundleNode bundle, Exception exception) {
        this.lock.lock();
        try {
            if (this.isCancelled()) {
                ArrayList<ServerJobBroadcast> list = new ArrayList<ServerJobBroadcast>(this.broadcastSet.size() + this.broadcastMap.size());
                list.addAll(this.broadcastMap.values());
                list.addAll(this.broadcastSet);
                this.broadcastSet.clear();
                for (ServerJobBroadcast broadcastJob : list) {
                    broadcastJob.cancel(false);
                }
            }
            super.taskCompleted(bundle, exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBundle(ServerTaskBundleClient bundle) {
        this.lock.lock();
        try {
            if (this.parentJob == null) {
                if (!super.addBundle(bundle)) {
                    boolean bl = false;
                    return bl;
                }
                for (ServerJobBroadcast item : this.broadcastSet) {
                    item.addBundle(bundle);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = super.addBundle(new ServerTaskBundleClient(bundle.getJob().copy(), bundle.getDataProvider(), bundle.getDataLocationList()));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

