/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import org.jppf.io.DataLocation;
import org.jppf.job.JobInformation;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.server.job.management.NodeJobInformation;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.server.protocol.ServerJobChangeListener;
import org.jppf.server.protocol.ServerTask;
import org.jppf.server.protocol.ServerTaskBundleClient;
import org.jppf.server.protocol.ServerTaskBundleNode;
import org.jppf.server.protocol.TaskState;
import org.jppf.server.protocol.utils.AbstractServerJob;
import org.jppf.server.protocol.utils.ServerJobStatus;
import org.jppf.server.submission.SubmissionStatus;
import org.jppf.utils.Pair;
import org.jppf.utils.ReflectionUtils;
import org.jppf.utils.collections.SetIdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerJob
extends AbstractServerJob {
    private static final Logger log = LoggerFactory.getLogger(ServerJob.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private final List<ServerTask> tasks = new ArrayList<ServerTask>();
    private final List<ServerTaskBundleClient> bundleList = new ArrayList<ServerTaskBundleClient>();
    private final ServerTaskBundleClient.CompletionListener bundleCompletionListener = new BundleCompletionListener();
    private final Set<ServerTaskBundleNode> dispatchSet = new LinkedHashSet<ServerTaskBundleNode>();
    private Runnable onRequeue = null;
    private final DataLocation dataProvider;

    public ServerJob(Lock lock, ServerJobChangeListener notificationEmitter, JPPFTaskBundle job, DataLocation dataProvider) {
        super(lock, job);
        this.notificationEmitter = notificationEmitter;
        this.dataProvider = dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ServerTaskBundleClient> getBundleList() {
        this.lock.lock();
        try {
            ArrayList<ServerTaskBundleClient> arrayList = new ArrayList<ServerTaskBundleClient>(this.bundleList);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public DataLocation getDataProvider() {
        return this.dataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskCount() {
        this.lock.lock();
        try {
            int n = this.tasks.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTaskBundleNode copy(int nbTasks) {
        JPPFTaskBundle taskBundle = this.getJob();
        this.lock.lock();
        try {
            ServerTaskBundleNode serverTaskBundleNode;
            int taskCount = nbTasks > this.tasks.size() ? this.tasks.size() : nbTasks;
            List<ServerTask> subList = this.tasks.subList(0, taskCount);
            try {
                if (taskBundle.getTaskCount() != taskCount) {
                    int newSize = taskBundle.getCurrentTaskCount() - taskCount;
                    taskBundle = taskBundle.copy();
                    taskBundle.setTaskCount(taskCount);
                    this.getJob().setCurrentTaskCount(newSize);
                }
                serverTaskBundleNode = new ServerTaskBundleNode(this, taskBundle, subList);
                subList.clear();
            }
            catch (Throwable throwable) {
                subList.clear();
                this.fireJobUpdated();
                throw throwable;
            }
            this.fireJobUpdated();
            return serverTaskBundleNode;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean merge(List<ServerTask> taskList, boolean after) {
        this.lock.lock();
        try {
            boolean requeue;
            boolean bl = requeue = this.tasks.isEmpty() && !taskList.isEmpty();
            if (!after) {
                this.tasks.addAll(0, taskList);
            } else {
                this.tasks.addAll(taskList);
            }
            boolean bl2 = requeue;
            return bl2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobDispatched(ServerTaskBundleNode bundle) {
        boolean empty;
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        Set<ServerTaskBundleNode> set = this.dispatchSet;
        synchronized (set) {
            empty = this.dispatchSet.isEmpty();
            this.dispatchSet.add(bundle);
        }
        if (empty) {
            this.updateStatus(ServerJobStatus.NEW, ServerJobStatus.EXECUTING);
            this.setSubmissionStatus(SubmissionStatus.EXECUTING);
        }
        this.fireJobDispatched(bundle.getChannel(), bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobReturned(ServerTaskBundleNode bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        Set<ServerTaskBundleNode> set = this.dispatchSet;
        synchronized (set) {
            this.dispatchSet.remove(bundle);
        }
        this.fireJobReturned(bundle.getChannel(), bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resultsReceived(ServerTaskBundleNode bundle, List<DataLocation> results) {
        if (results.isEmpty()) {
            return;
        }
        if (debugEnabled) {
            log.debug("*** received " + results.size() + " results from " + bundle);
        }
        SetIdentityMap map = new SetIdentityMap();
        this.lock.lock();
        try {
            List<ServerTask> bundleTasks;
            List<ServerTask> list = bundleTasks = bundle == null ? new ArrayList<ServerTask>(this.tasks) : bundle.getTaskList();
            if (this.isJobExpired() || this.isCancelled()) {
                for (ServerTask task : bundleTasks) {
                    map.putValue((Object)task.getBundle(), (Object)new Pair((Object)task.getPosition(), (Object)task.getDataLocation()));
                }
            } else {
                for (int index = 0; index < bundleTasks.size(); ++index) {
                    ServerTask task;
                    task = bundleTasks.get(index);
                    DataLocation location = results.get(index);
                    map.putValue((Object)task.getBundle(), (Object)new Pair((Object)task.getPosition(), (Object)location));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (Map.Entry entry : map.entrySet()) {
            ((ServerTaskBundleClient)entry.getKey()).resultReceived((Collection)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resultsReceived(ServerTaskBundleNode bundle, Throwable throwable) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        SetIdentityMap map = new SetIdentityMap();
        this.lock.lock();
        try {
            for (ServerTask task : bundle.getTaskList()) {
                map.putValue((Object)task.getBundle(), (Object)task);
            }
        }
        finally {
            this.lock.unlock();
        }
        for (Map.Entry entry : map.entrySet()) {
            ((ServerTaskBundleClient)entry.getKey()).resultReceived((Collection)entry.getValue(), throwable);
        }
    }

    private static void addAll(List<DataLocation> dst, List<ServerTask> src) {
        for (ServerTask item : src) {
            dst.add(item.getDataLocation());
        }
    }

    private static void addExcluded(List<DataLocation> dst, List<ServerTask> src, TaskState state) {
        for (ServerTask item : src) {
            if (item.getState() == state) continue;
            dst.add(item.getDataLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void taskCompleted(ServerTaskBundleNode bundle, Exception exception) {
        this.lock.lock();
        try {
            if (this.isCancelled()) {
                ArrayList futureList;
                Set<ServerTaskBundleNode> set = this.dispatchSet;
                synchronized (set) {
                    futureList = new ArrayList(this.dispatchSet.size());
                    for (ServerTaskBundleNode item : this.dispatchSet) {
                        futureList.add(item.getFuture());
                    }
                }
                for (Future future : futureList) {
                    try {
                        if (future.isDone()) continue;
                        future.cancel(false);
                    }
                    catch (Exception e) {
                        log.error("Error cancelling job " + this, (Throwable)e);
                    }
                }
            }
            boolean requeue = false;
            ArrayList<DataLocation> list = new ArrayList<DataLocation>();
            if (this.getSLA().isBroadcastJob()) {
                if (bundle != null) {
                    ServerJob.addExcluded(list, bundle.getTaskList(), TaskState.RESULT);
                }
                if (this.isCancelled() || this.getBroadcastUUID() == null) {
                    ServerJob.addAll(list, this.tasks);
                }
            } else if (bundle == null) {
                if (this.isCancelled()) {
                    ServerJob.addAll(list, this.tasks);
                }
            } else {
                if (bundle.isCancelled()) {
                    ServerJob.addExcluded(list, bundle.getTaskList(), TaskState.RESULT);
                    ServerJob.addAll(list, this.tasks);
                }
                if (bundle.isRequeued()) {
                    ArrayList<ServerTask> arrayList = new ArrayList<ServerTask>();
                    for (ServerTask task : bundle.getTaskList()) {
                        if (task.getState() == TaskState.RESULT) continue;
                        arrayList.add(task);
                    }
                    requeue = this.merge(arrayList, false);
                }
            }
            if (!list.isEmpty()) {
                try {
                    this.resultsReceived(bundle, list);
                }
                finally {
                    this.tasks.clear();
                }
            }
            if (this.hasPending()) {
                if (exception != null) {
                    this.setSubmissionStatus(SubmissionStatus.FAILED);
                }
                if (requeue && this.onRequeue != null) {
                    this.onRequeue.run();
                }
            } else {
                this.setSubmissionStatus(SubmissionStatus.COMPLETE);
                this.fireTaskCompleted(this);
            }
            if (this.bundleList.isEmpty() && this.tasks.isEmpty()) {
                this.setSubmissionStatus(SubmissionStatus.ENDED);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void fireTaskCompleted(ServerJob result) {
        this.getJob().fireTaskCompleted(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPending() {
        this.lock.lock();
        try {
            for (ServerTaskBundleClient bundle : this.bundleList) {
                if (bundle.getPendingTasksCount() <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (debugEnabled) {
            log.debug("request to cancel " + this);
        }
        this.lock.lock();
        try {
            if (super.cancel(mayInterruptIfRunning)) {
                this.taskCompleted(null, null);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setOnRequeue(Runnable onRequeue) {
        if (this.getSLA().isBroadcastJob()) {
            return;
        }
        this.onRequeue = onRequeue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNbChannels() {
        Set<ServerTaskBundleNode> set = this.dispatchSet;
        synchronized (set) {
            return this.dispatchSet.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeJobInformation[] getNodeJobInformation() {
        ServerTaskBundleNode[] entries;
        Set<ServerTaskBundleNode> set = this.dispatchSet;
        synchronized (set) {
            entries = this.dispatchSet.toArray(new ServerTaskBundleNode[this.dispatchSet.size()]);
        }
        if (entries.length == 0) {
            return NodeJobInformation.EMPTY_ARRAY;
        }
        NodeJobInformation[] result = new NodeJobInformation[entries.length];
        int i = 0;
        for (ServerTaskBundleNode bundle : entries) {
            JPPFManagementInfo nodeInfo = bundle.getChannel().getManagementInfo();
            boolean pending = Boolean.TRUE.equals(bundle.getParameter((Object)BundleParameter.JOB_PENDING));
            JobInformation jobInfo = new JobInformation(this.getUuid(), bundle.getName(), bundle.getTaskCount(), bundle.getInitialTaskCount(), bundle.getSLA().getPriority(), bundle.getSLA().isSuspended(), pending);
            jobInfo.setMaxNodes(bundle.getSLA().getMaxNodes());
            result[i++] = new NodeJobInformation(nodeInfo, jobInfo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBundle(ServerTaskBundleClient bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle is null");
        }
        this.lock.lock();
        try {
            if (this.getSubmissionStatus() == SubmissionStatus.COMPLETE) {
                if (this.completionBundles == null) {
                    this.completionBundles = new ArrayList();
                }
                this.completionBundles.add(bundle);
                boolean bl = false;
                return bl;
            }
            if (this.getSubmissionStatus() == SubmissionStatus.ENDED) {
                throw new IllegalStateException("Job ENDED");
            }
            this.bundleList.add(bundle);
            this.tasks.addAll(bundle.getTaskList());
            bundle.addCompletionListener(this.bundleCompletionListener);
            this.fireJobUpdated();
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return ReflectionUtils.dumpObject((Object)this, "uuid", "broadcastJob", "broadcastUUID", "submissionStatus", "taskCount", "nbBundles", "nbCHannels", "cancelled", "expired", "pending", "suspended");
    }

    public int getNbBundles() {
        return this.bundleList.size();
    }

    private class BundleCompletionListener
    implements ServerTaskBundleClient.CompletionListener {
        private BundleCompletionListener() {
        }

        @Override
        public void taskCompleted(ServerTaskBundleClient bundle, List<ServerTask> results) {
            if (bundle == null) {
                throw new IllegalArgumentException("bundle is null");
            }
            if (bundle.isCancelled()) {
                ServerJob.this.cancel(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void bundleEnded(ServerTaskBundleClient bundle) {
            if (bundle == null) {
                throw new IllegalArgumentException("bundle is null");
            }
            ServerJob.this.lock.lock();
            try {
                bundle.removeCompletionListener(this);
                ServerJob.this.bundleList.remove(bundle);
                ServerJob.this.tasks.removeAll(bundle.getTaskList());
                if (ServerJob.this.bundleList.isEmpty() && ServerJob.this.tasks.isEmpty() && ServerJob.this.getSubmissionStatus() == SubmissionStatus.COMPLETE) {
                    ServerJob.this.setSubmissionStatus(SubmissionStatus.ENDED);
                }
            }
            finally {
                ServerJob.this.lock.unlock();
            }
        }
    }
}

