/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.JobMetadata;
import org.jppf.node.protocol.JobSLA;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFJobMetadata;
import org.jppf.server.protocol.JPPFJobSLA;
import org.jppf.server.protocol.ServerJob;
import org.jppf.server.protocol.TaskCompletionListener;
import org.jppf.utils.ReflectionUtils;
import org.jppf.utils.TraversalList;

public class JPPFTaskBundle
implements Serializable,
Comparable<JPPFTaskBundle>,
JPPFDistributedJob {
    private static final long serialVersionUID = 1L;
    private String jobUuid = null;
    private String requestUuid = null;
    private String name = null;
    private TraversalList<String> uuidPath = new TraversalList();
    protected int taskCount = 0;
    protected int currentTaskCount = 0;
    protected int initialTaskCount = 0;
    private transient long queueEntryTime = 0L;
    private transient TaskCompletionListener completionListener = null;
    private long nodeExecutionTime = 0L;
    private long executionStartTime = 0L;
    private State state = State.EXECUTION_BUNDLE;
    private final Map<Object, Object> parameters = new HashMap<Object, Object>();
    private JobSLA jobSLA = new JPPFJobSLA();
    private JobMetadata jobMetadata = new JPPFJobMetadata();
    private static AtomicLong copyCount = new AtomicLong(0L);

    public String getRequestUuid() {
        return this.requestUuid == null ? this.getUuid() : this.requestUuid;
    }

    public void setRequestUuid(String requestUuid) {
        this.requestUuid = requestUuid;
    }

    public TraversalList<String> getUuidPath() {
        return this.uuidPath;
    }

    public void setUuidPath(TraversalList<String> uuidPath) {
        this.uuidPath = uuidPath;
    }

    public long getQueueEntryTime() {
        return this.queueEntryTime;
    }

    public void setQueueEntryTime(long queueEntryTime) {
        this.queueEntryTime = queueEntryTime;
    }

    public long getNodeExecutionTime() {
        return this.nodeExecutionTime;
    }

    public void setNodeExecutionTime(long nodeExecutionTime) {
        this.nodeExecutionTime = nodeExecutionTime;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public void setTaskCount(int taskCount) {
        this.taskCount = taskCount;
        if (this.initialTaskCount <= 0) {
            this.initialTaskCount = taskCount;
        }
        if (this.currentTaskCount <= 0) {
            this.currentTaskCount = taskCount;
        }
    }

    public TaskCompletionListener getCompletionListener() {
        return this.completionListener;
    }

    public void setCompletionListener(TaskCompletionListener listener) {
        this.completionListener = listener;
    }

    public void fireTaskCompleted(ServerJob result) {
        if (this.completionListener != null) {
            this.completionListener.taskCompleted(result);
        }
    }

    @Override
    public int compareTo(JPPFTaskBundle bundle) {
        if (bundle == null) {
            return 1;
        }
        int otherPriority = bundle.getSLA().getPriority();
        if (this.jobSLA.getPriority() < otherPriority) {
            return -1;
        }
        if (this.jobSLA.getPriority() > otherPriority) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFTaskBundle copy() {
        JPPFTaskBundle bundle = new JPPFTaskBundle();
        bundle.setUuidPath(this.uuidPath);
        bundle.setRequestUuid(this.getRequestUuid());
        bundle.setUuid(this.getUuid());
        bundle.setName(this.name);
        bundle.setTaskCount(this.taskCount);
        Map<Object, Object> map = bundle.getParametersMap();
        synchronized (map) {
            for (Map.Entry<Object, Object> entry : this.parameters.entrySet()) {
                bundle.setParameter(entry.getKey(), entry.getValue());
            }
        }
        bundle.setQueueEntryTime(this.queueEntryTime);
        bundle.setCompletionListener(this.completionListener);
        bundle.setSLA(this.jobSLA);
        bundle.setMetadata(this.jobMetadata);
        bundle.setParameter("bundle.uuid", (String)this.uuidPath.getLast() + '-' + copyCount.incrementAndGet());
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPPFTaskBundle copy(int nbTasks) {
        JPPFTaskBundle bundle = this.copy();
        JPPFTaskBundle jPPFTaskBundle = this;
        synchronized (jPPFTaskBundle) {
            bundle.setTaskCount(nbTasks);
            this.taskCount -= nbTasks;
        }
        return bundle;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public long getExecutionStartTime() {
        return this.executionStartTime;
    }

    public void setExecutionStartTime(long executionStartTime) {
        this.executionStartTime = executionStartTime;
    }

    public int getInitialTaskCount() {
        return this.initialTaskCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(Object name, Object value) {
        Map<Object, Object> map = this.parameters;
        synchronized (map) {
            this.parameters.put(name, value);
        }
    }

    public Object getParameter(Object name) {
        return this.parameters.get(name);
    }

    public Object getParameter(Object name, Object defaultValue) {
        Object res = this.parameters.get(name);
        return res == null ? defaultValue : res;
    }

    public Object removeParameter(Object name) {
        return this.parameters.remove(name);
    }

    public Map<Object, Object> getParametersMap() {
        return this.parameters;
    }

    public JobSLA getSLA() {
        return this.jobSLA;
    }

    public void setSLA(JobSLA jobSLA) {
        this.jobSLA = jobSLA;
    }

    public String toString() {
        return ReflectionUtils.dumpObject((Object)this, "name", "uuid", "initialTaskCount", "taskCount", "bundleUuid", "uuidPath", "requeue");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JobMetadata getMetadata() {
        return this.jobMetadata;
    }

    public void setMetadata(JobMetadata jobMetadata) {
        this.jobMetadata = jobMetadata;
    }

    public String getUuid() {
        return this.jobUuid;
    }

    public void setUuid(String jobUuid) {
        this.jobUuid = jobUuid;
    }

    public int getCurrentTaskCount() {
        return this.currentTaskCount;
    }

    public void setCurrentTaskCount(int currentTaskCount) {
        this.currentTaskCount = currentTaskCount;
    }

    public Object getBundleUuid() {
        return this.getParameter("bundle.uuid");
    }

    public Object getRequeue() {
        return this.getParameter((Object)BundleParameter.JOB_REQUEUE);
    }

    public static enum State {
        INITIAL_BUNDLE,
        EXECUTION_BUNDLE;

    }
}

