/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.Serializable;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.node.protocol.Task;
import org.jppf.scheduling.JPPFSchedule;
import org.jppf.server.protocol.JPPFTaskListener;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.JPPFCallable;
import org.jppf.utils.ObjectSerializer;

public abstract class JPPFTask
implements Task<Object> {
    private static final long serialVersionUID = 1L;
    private int position;
    private Object result = null;
    private Exception exception = null;
    private transient DataProvider dataProvider = null;
    private JPPFSchedule timeoutSchedule = null;
    private boolean inNode = false;
    private String id = null;

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int position) {
        this.position = position;
    }

    public synchronized void addJPPFTaskListener(JPPFTaskListener listener) {
    }

    public synchronized void removeJPPFTaskListener(JPPFTaskListener listener) {
    }

    public synchronized void fireNotification(Serializable source) {
    }

    public long getTimeout() {
        if (this.timeoutSchedule == null) {
            return 0L;
        }
        return this.timeoutSchedule.getDuration();
    }

    public void setTimeout(long timeout) {
        this.timeoutSchedule = new JPPFSchedule(timeout);
    }

    public String getTimeoutDate() {
        if (this.timeoutSchedule == null) {
            return null;
        }
        return this.timeoutSchedule.getDate();
    }

    public String getTimeoutFormat() {
        if (this.timeoutSchedule == null) {
            return null;
        }
        return this.timeoutSchedule.getFormat();
    }

    public void setTimeoutDate(String timeoutDate, String format) {
        this.timeoutSchedule = new JPPFSchedule(timeoutDate, format);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void onCancel() {
    }

    public void onRestart() {
    }

    public void onTimeout() {
    }

    public Object getTaskObject() {
        return this;
    }

    public JPPFSchedule getTimeoutSchedule() {
        return this.timeoutSchedule;
    }

    public void setTimeoutSchedule(JPPFSchedule timeoutSchedule) {
        this.timeoutSchedule = timeoutSchedule;
    }

    public boolean isInNode() {
        return this.inNode;
    }

    public void setInNode(boolean inNode) {
        this.inNode = inNode;
    }

    public <V> V compute(JPPFCallable<V> callable) throws Exception {
        ClassLoader cl = callable.getClass().getClassLoader();
        Object result = null;
        Object returned = null;
        try {
            if (this.isInNode()) {
                if (cl instanceof AbstractJPPFClassLoader) {
                    AbstractJPPFClassLoader loader = (AbstractJPPFClassLoader)cl;
                    Class clazz = loader.loadClass("org.jppf.utils.ObjectSerializerImpl");
                    ObjectSerializer ser = (ObjectSerializer)clazz.newInstance();
                    byte[] bytes = ser.serialize(callable).getBuffer();
                    if ((bytes = loader.computeRemoteData(bytes)) == null) {
                        return null;
                    }
                    returned = ser.deserialize(bytes);
                    if (returned instanceof Exception) {
                        throw (Exception)returned;
                    }
                    result = returned;
                }
            } else {
                result = callable.call();
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return (V)result;
    }
}

