/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jppf.server.protocol.JPPFTask;

public abstract class JPPFOptimizedTask
extends JPPFTask {
    private byte serializationCount = 0;
    private byte deserializationCount = 0;

    protected void serialize(ObjectOutputStream out) throws IOException {
        byte count = this.serializationCount;
        this.serializationCount = (byte)(this.serializationCount + 1);
        out.write(this.serializationCount);
        out.write(this.deserializationCount);
        if (count > 0) {
            out.writeInt(this.getPosition());
            out.writeObject(this.getId());
            out.writeObject(this.getResult());
            out.writeObject(this.getException());
        } else {
            out.defaultWriteObject();
        }
    }

    protected void deserialize(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serializationCount = (byte)in.read();
        this.deserializationCount = (byte)in.read();
        if (this.deserializationCount > 0) {
            this.setPosition(in.readInt());
            this.setId((String)in.readObject());
            this.setResult(in.readObject());
            this.setException((Exception)in.readObject());
        } else {
            in.defaultReadObject();
        }
        this.deserializationCount = (byte)(this.deserializationCount + 1);
    }
}

