/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import org.jppf.JPPFException;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.utils.ExceptionUtils;

public final class JPPFExceptionResult
extends JPPFTask {
    private static final long serialVersionUID = 1L;
    private final String objectDescriptor;
    private final String className;

    public JPPFExceptionResult(Throwable throwable, Object object) {
        if (throwable instanceof Exception) {
            this.setException((Exception)throwable);
        } else {
            this.setException((Exception)new JPPFException(throwable));
        }
        this.objectDescriptor = String.valueOf(object);
        this.className = object != null ? object.getClass().getName() : "unknown class";
    }

    public void run() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Error occurred on object [").append(this.objectDescriptor).append("], class=").append(this.className);
        if (this.getException() != null) {
            sb.append(" :\n").append(ExceptionUtils.getStackTrace((Throwable)this.getException()));
        }
        return sb.toString();
    }

    public String getObjectDescriptor() {
        return this.objectDescriptor;
    }

    public String getTaskClassName() {
        return this.className;
    }
}

