/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jppf.node.ThreadManager;
import org.jppf.server.node.AbstractThreadManager;
import org.jppf.utils.JPPFThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadManagerThreadPool
extends AbstractThreadManager {
    private static Logger log = LoggerFactory.getLogger(ThreadManagerThreadPool.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private ThreadPoolExecutor threadPool;
    private JPPFThreadFactory threadFactory = new JPPFThreadFactory("node processing", this.cpuTimeEnabled);

    public ThreadManagerThreadPool(int poolSize) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
        this.threadPool = new ThreadPoolExecutor(poolSize, poolSize, Long.MAX_VALUE, TimeUnit.MICROSECONDS, queue, (ThreadFactory)this.threadFactory);
    }

    @Override
    protected long[] getThreadIds() {
        return this.threadFactory.getThreadIDs();
    }

    public ExecutorService getExecutorService() {
        return this.threadPool;
    }

    public void setPoolSize(int size) {
        if (size <= 0) {
            log.warn("ignored attempt to set the thread pool size to 0 or less: " + size);
            return;
        }
        int n = this.getPoolSize();
        if (n == size) {
            return;
        }
        ThreadPoolExecutor tpe = this.threadPool;
        if (size > tpe.getCorePoolSize()) {
            tpe.setMaximumPoolSize(size);
            tpe.setCorePoolSize(size);
        } else if (size < tpe.getCorePoolSize()) {
            tpe.setCorePoolSize(size);
            tpe.setMaximumPoolSize(size);
        }
    }

    public int getPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    public int getPriority() {
        return this.threadFactory.getPriority();
    }

    public void setPriority(int priority) {
        this.threadFactory.updatePriority(priority);
    }

    public ThreadManager.UsedClassLoader useClassLoader(ClassLoader classLoader) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return new UsedClassLoaderThread(classLoader, oldClassLoader);
    }

    private static final class UsedClassLoaderThread
    extends ThreadManager.UsedClassLoader {
        private final ClassLoader oldClassLoader;

        private UsedClassLoaderThread(ClassLoader classLoader, ClassLoader oldClassLoader) {
            super(classLoader);
            this.oldClassLoader = oldClassLoader;
        }

        public void dispose() {
            if (this.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(this.oldClassLoader);
            }
        }
    }
}

