/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.concurrent.Future;
import org.jppf.JPPFException;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.node.NodeExecutionInfo;
import org.jppf.node.ThreadManager;
import org.jppf.node.protocol.Task;
import org.jppf.scheduling.JPPFSchedule;
import org.jppf.server.node.AbstractNodeTaskWrapper;
import org.jppf.server.node.NodeExecutionManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeTaskWrapper
extends AbstractNodeTaskWrapper {
    private static Logger log = LoggerFactory.getLogger(NodeTaskWrapper.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private final NodeExecutionManagerImpl executionManager;
    private final ClassLoader classLoader;
    private boolean cancelled = false;
    private boolean callOnCancel = false;
    private boolean timeout = false;
    private boolean started = false;

    public NodeTaskWrapper(NodeExecutionManagerImpl executionManager, Task task, long number, ClassLoader classLoader) {
        super(task, number);
        this.executionManager = executionManager;
        this.classLoader = classLoader;
    }

    public synchronized void cancel(boolean callOnCancel) {
        Future future;
        this.cancelled = true;
        this.callOnCancel |= callOnCancel;
        if (this.task instanceof Future && !(future = (Future)this.task).isDone()) {
            future.cancel(true);
        }
    }

    public synchronized void timeout() {
        Future future;
        this.timeout |= !this.cancelled;
        if (!this.cancelled && !this.started) {
            this.executionManager.removeFuture(this.number);
        }
        if (this.task instanceof Future && !(future = (Future)this.task).isDone()) {
            future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (traceEnabled) {
            log.trace(this.toString());
        }
        this.setStarted();
        JPPFNodeReconnectionNotification rn = null;
        ThreadManager.UsedClassLoader usedClassLoader = null;
        ThreadManager threadManager = this.executionManager.getThreadManager();
        NodeExecutionInfo info = null;
        long elapsedTime = 0L;
        long id = Thread.currentThread().getId();
        long startTime = System.nanoTime();
        try {
            usedClassLoader = threadManager.useClassLoader(this.classLoader);
            this.handleTimeout();
            info = threadManager.computeExecutionInfo(id);
            if (!this.isCancelledOrTimedout()) {
                this.task.run();
            }
        }
        catch (JPPFNodeReconnectionNotification t) {
            rn = t;
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                this.task.setException((Exception)t);
            } else {
                this.task.setException((Exception)new JPPFException(t));
            }
        }
        finally {
            try {
                elapsedTime = System.nanoTime() - startTime;
                if (info != null) {
                    info = threadManager.computeExecutionInfo(id).subtract(info);
                }
            }
            catch (Throwable ignore) {}
            try {
                this.silentTimeout();
                this.silentCancel();
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    this.task.setException((Exception)t);
                }
                this.task.setException((Exception)new JPPFException(t));
            }
            if (this.task.getException() instanceof InterruptedException) {
                this.task.setException(null);
            }
            if (usedClassLoader != null) {
                usedClassLoader.dispose();
            }
            this.executionManager.removeFuture(this.number);
            if (rn == null) {
                try {
                    this.executionManager.taskEnded(this.task, this.number, info, elapsedTime);
                }
                catch (JPPFNodeReconnectionNotification t) {
                    rn = t;
                }
            }
            if (rn != null) {
                this.executionManager.setReconnectionNotification(rn);
            }
        }
    }

    protected synchronized boolean silentTimeout() {
        if (this.timeout) {
            this.task.onTimeout();
        }
        return this.timeout;
    }

    protected synchronized boolean silentCancel() {
        if (this.cancelled && this.callOnCancel) {
            this.task.onCancel();
        }
        return this.cancelled;
    }

    protected synchronized void setStarted() {
        this.started = true;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized boolean isCancelledOrTimedout() {
        return this.cancelled || this.timeout;
    }

    void handleTimeout() throws Exception {
        JPPFSchedule schedule = this.task.getTimeoutSchedule();
        if (schedule != null && (schedule.getDuration() > 0L || schedule.getDate() != null)) {
            this.executionManager.processTaskTimeout(this, this.number);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("task number=").append(this.number);
        sb.append(", cancelled=").append(this.cancelled);
        sb.append(", callOnCancel=").append(this.callOnCancel);
        sb.append(", timeout=").append(this.timeout);
        sb.append(", started=").append(this.started);
        sb.append(']');
        return sb.toString();
    }
}

