/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.node.Node;
import org.jppf.node.NodeExecutionInfo;
import org.jppf.node.NodeExecutionManager;
import org.jppf.node.ThreadManager;
import org.jppf.node.protocol.JPPFDistributedJob;
import org.jppf.node.protocol.Task;
import org.jppf.scheduling.JPPFScheduleHandler;
import org.jppf.server.node.ClassLoaderProvider;
import org.jppf.server.node.NodeTaskWrapper;
import org.jppf.server.node.TaskExecutionEvent;
import org.jppf.server.node.TaskExecutionListener;
import org.jppf.server.node.ThreadManagerThreadPool;
import org.jppf.server.node.TimeoutTimerTask;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ReflectionHelper;
import org.jppf.utils.ThreadSynchronization;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeExecutionManagerImpl
extends ThreadSynchronization
implements NodeExecutionManager {
    private static final Logger log = LoggerFactory.getLogger(NodeExecutionManagerImpl.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private Node node = null;
    protected final JPPFScheduleHandler timeoutHandler = new JPPFScheduleHandler("Task Timeout Timer");
    protected final Map<Long, NodeTaskWrapper> taskMap = new Hashtable<Long, NodeTaskWrapper>();
    protected JPPFTaskBundle bundle = null;
    protected List<? extends Task> taskList = null;
    protected List<String> uuidList = null;
    protected final Map<Long, Future<?>> futureMap = new Hashtable();
    protected final AtomicLong taskCount = new AtomicLong(0L);
    private final List<TaskExecutionListener> taskExecutionListeners = new ArrayList<TaskExecutionListener>();
    private TaskExecutionListener[] listenersArray = new TaskExecutionListener[0];
    protected final AtomicBoolean configChanged = new AtomicBoolean(true);
    protected JPPFNodeReconnectionNotification reconnectionNotification = null;
    private final ThreadManager threadManager;
    private boolean jobCancelled = false;
    private AbstractJPPFClassLoader taskClassLoader = null;
    private DataProvider dataProvider = null;
    private final AtomicLong accumulatedElapsed = new AtomicLong(0L);

    public NodeExecutionManagerImpl(Node node) {
        this(node, "processing.threads");
    }

    public NodeExecutionManagerImpl(Node node, String nbThreadsProperty) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.node = node;
        TypedProperties config = JPPFConfiguration.getProperties();
        int poolSize = config.getInt(nbThreadsProperty, Runtime.getRuntime().availableProcessors());
        if (poolSize <= 0) {
            poolSize = Runtime.getRuntime().availableProcessors();
            config.setProperty(nbThreadsProperty, Integer.toString(poolSize));
        }
        log.info("running " + poolSize + " processing thread" + (poolSize > 1 ? "s" : ""));
        this.threadManager = NodeExecutionManagerImpl.createThreadManager(config, poolSize);
    }

    private static ThreadManager createThreadManager(TypedProperties config, int poolSize) {
        ThreadManager result = null;
        String s = config.getString("jppf.thread.manager.class", "default");
        if (!"default".equalsIgnoreCase(s) && !"org.jppf.server.node.ThreadManagerThreadPool".equals(s) && s != null) {
            try {
                Class<?> clazz = Class.forName(s);
                Object instance = ReflectionHelper.invokeConstructor(clazz, new Class[]{Integer.TYPE}, poolSize);
                if (instance instanceof ThreadManager) {
                    result = (ThreadManager)instance;
                    log.info("Using custom thread manager: " + s);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (result == null) {
            log.info("Using default thread manager");
            return new ThreadManagerThreadPool(poolSize);
        }
        config.setProperty("processing.threads", Integer.toString(result.getPoolSize()));
        log.info("Node running " + poolSize + " processing thread" + (poolSize > 1 ? "s" : ""));
        boolean cpuTimeEnabled = result.isCpuTimeEnabled();
        config.setProperty("cpuTimeSupported", Boolean.toString(cpuTimeEnabled));
        log.info("Thread CPU time measurement is " + (cpuTimeEnabled ? "" : "not ") + "supported");
        return result;
    }

    public void execute(JPPFTaskBundle bundle, List<? extends Task> taskList) throws Exception {
        if (taskList == null || taskList.isEmpty()) {
            return;
        }
        if (debugEnabled) {
            log.debug("executing " + taskList.size() + " tasks");
        }
        NodeExecutionInfo info = this.threadManager.isCpuTimeEnabled() ? this.threadManager.computeExecutionInfo() : null;
        this.setup(bundle, taskList);
        if (!this.isJobCancelled()) {
            for (Task task : taskList) {
                this.performTask(task);
            }
            this.waitForResults();
        }
        this.cleanup();
        if (info != null) {
            NodeExecutionInfo info2 = this.threadManager.computeExecutionInfo().subtract(info);
            if (debugEnabled) {
                log.debug("total cpu time used: " + info2.cpuTime / 1000000L + " ms, user time: " + info2.userTime / 1000000L);
            }
        }
    }

    public synchronized long performTask(Task task) throws Exception {
        long number = this.incTaskCount();
        NodeTaskWrapper taskWrapper = new NodeTaskWrapper(this, task, number, (ClassLoader)this.taskClassLoader);
        this.taskMap.put(number, taskWrapper);
        Future<?> f = this.getExecutor().submit(taskWrapper);
        if (!f.isDone()) {
            this.futureMap.put(number, f);
        }
        return number;
    }

    public synchronized void cancelAllTasks(boolean callOnCancel, boolean requeue) {
        if (debugEnabled) {
            log.debug("cancelling all tasks with: callOnCancel=" + callOnCancel + ", requeue=" + requeue);
        }
        if (requeue) {
            this.bundle.setParameter((Object)BundleParameter.JOB_REQUEUE, true);
            this.bundle.getSLA().setSuspended(true);
        }
        ArrayList<Long> list = new ArrayList<Long>(this.futureMap.keySet());
        for (Long n : list) {
            this.cancelTask(n, callOnCancel);
        }
    }

    private synchronized void cancelTask(Long number, boolean callOnCancel) {
        Future<?> future;
        if (debugEnabled) {
            log.debug("cancelling task number = " + number);
        }
        if (!(future = this.futureMap.get(number)).isDone()) {
            NodeTaskWrapper taskWrapper;
            if (debugEnabled) {
                log.debug("calling future.cancel(true) for task number = " + number);
            }
            if ((taskWrapper = this.taskMap.remove(number)) != null) {
                taskWrapper.cancel(callOnCancel);
            }
            future.cancel(true);
            this.removeFuture(number);
        }
    }

    void processTaskTimeout(NodeTaskWrapper taskWrapper, long number) throws Exception {
        Future<?> future = this.getFutureFromNumber(number);
        TimeoutTimerTask tt = new TimeoutTimerTask(future, taskWrapper);
        this.timeoutHandler.scheduleAction(future, taskWrapper.getTask().getTimeoutSchedule(), (Runnable)tt);
    }

    public void shutdown() {
        this.getExecutor().shutdownNow();
        this.timeoutHandler.clear(true);
    }

    public void setup(JPPFTaskBundle bundle, List<? extends Task> taskList) {
        this.bundle = bundle;
        this.taskList = taskList;
        this.dataProvider = taskList.get(0).getDataProvider();
        this.uuidList = bundle.getUuidPath().getList();
        try {
            this.taskClassLoader = (AbstractJPPFClassLoader)(this.node instanceof ClassLoaderProvider ? ((ClassLoaderProvider)this.node).getClassLoader(this.uuidList) : null);
        }
        catch (Exception e) {
            String msg = ExceptionUtils.getMessage((Throwable)e) + " - class loader lookup failed for uuidPath=" + this.uuidList;
            if (debugEnabled) {
                log.debug(msg, (Throwable)e);
            }
            log.warn(msg);
        }
        this.taskCount.set(0L);
        this.accumulatedElapsed.set(0L);
        this.node.getLifeCycleEventHandler().fireJobStarting((JPPFDistributedJob)bundle, this.taskClassLoader, taskList, this.dataProvider);
    }

    public void cleanup() {
        this.bundle.setParameter((Object)BundleParameter.NODE_BUNDLE_ELAPSED_PARAM, this.accumulatedElapsed.get());
        this.node.getLifeCycleEventHandler().fireJobEnding((JPPFDistributedJob)this.bundle, this.taskClassLoader, this.taskList, this.dataProvider);
        this.taskClassLoader = null;
        this.bundle = null;
        this.taskList = null;
        this.uuidList = null;
        this.setJobCancelled(false);
        this.futureMap.clear();
        this.taskMap.clear();
        this.timeoutHandler.clear();
    }

    public synchronized void waitForResults() throws Exception {
        while (!this.futureMap.isEmpty() && this.getReconnectionNotification() == null) {
            this.goToSleep();
        }
        if (this.getReconnectionNotification() != null) {
            this.cancelAllTasks(true, false);
            throw this.reconnectionNotification;
        }
    }

    public synchronized void removeFuture(long number) {
        Future<?> future = this.futureMap.remove(number);
        if (future != null) {
            this.timeoutHandler.cancelAction(future);
        }
        this.wakeUp();
    }

    private long incTaskCount() {
        return this.taskCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskEnded(Task task, long taskNumber, NodeExecutionInfo info, long elapsedTime) {
        TaskExecutionListener[] tmp;
        this.accumulatedElapsed.addAndGet(elapsedTime);
        long cpuTime = info == null ? 0L : info.cpuTime / 1000000L;
        TaskExecutionEvent event = new TaskExecutionEvent(task, this.getCurrentJobId(), cpuTime, elapsedTime / 1000000L, task.getException() != null);
        List<TaskExecutionListener> list = this.taskExecutionListeners;
        synchronized (list) {
            tmp = this.listenersArray;
        }
        for (TaskExecutionListener listener : tmp) {
            listener.taskExecuted(event);
        }
    }

    public synchronized Future<?> getFutureFromNumber(long number) {
        return this.futureMap.get(number);
    }

    public JPPFDistributedJob getCurrentJob() {
        return this.bundle;
    }

    public List<Task> getTasks() {
        return this.taskList == null ? null : Collections.unmodifiableList(this.taskList);
    }

    public String getCurrentJobId() {
        return this.bundle != null ? this.bundle.getUuid() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskExecutionListener(TaskExecutionListener listener) {
        List<TaskExecutionListener> list = this.taskExecutionListeners;
        synchronized (list) {
            this.taskExecutionListeners.add(listener);
            this.listenersArray = this.taskExecutionListeners.toArray(new TaskExecutionListener[this.taskExecutionListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        List<TaskExecutionListener> list = this.taskExecutionListeners;
        synchronized (list) {
            this.taskExecutionListeners.remove(listener);
            this.listenersArray = this.taskExecutionListeners.toArray(new TaskExecutionListener[this.taskExecutionListeners.size()]);
        }
    }

    public ExecutorService getExecutor() {
        return this.threadManager.getExecutorService();
    }

    public boolean checkConfigChanged() {
        return this.configChanged.compareAndSet(true, false);
    }

    public void triggerConfigChanged() {
        this.configChanged.compareAndSet(false, true);
    }

    public synchronized JPPFNodeReconnectionNotification getReconnectionNotification() {
        return this.reconnectionNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setReconnectionNotification(JPPFNodeReconnectionNotification reconnectionNotification) {
        try {
            if (this.reconnectionNotification != null) {
                return;
            }
            this.reconnectionNotification = reconnectionNotification;
        }
        finally {
            this.wakeUp();
        }
    }

    public Node getNode() {
        return this.node;
    }

    public void setThreadPoolSize(int size) {
        if (size <= 0) {
            log.warn("ignored attempt to set the thread pool size to 0 or less: " + size);
            return;
        }
        int oldSize = this.getThreadPoolSize();
        this.threadManager.setPoolSize(size);
        int newSize = this.getThreadPoolSize();
        if (oldSize != newSize) {
            log.info("Node thread pool size changed from " + oldSize + " to " + size);
            JPPFConfiguration.getProperties().setProperty("processing.threads", Integer.toString(size));
            this.configChanged.set(true);
        }
    }

    public int getThreadPoolSize() {
        return this.threadManager.getPoolSize();
    }

    public int getThreadsPriority() {
        return this.threadManager.getPriority();
    }

    public void updateThreadsPriority(int newPriority) {
        this.threadManager.setPriority(newPriority);
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public synchronized boolean isJobCancelled() {
        return this.jobCancelled;
    }

    public synchronized void setJobCancelled(boolean jobCancelled) {
        this.jobCancelled = jobCancelled;
    }
}

