/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jppf.JPPFError;
import org.jppf.JPPFNodeReconnectionNotification;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFClassLoader;
import org.jppf.management.JMXServer;
import org.jppf.management.JMXServerFactory;
import org.jppf.management.JPPFNodeAdminMBean;
import org.jppf.management.JPPFSystemInformation;
import org.jppf.management.spi.JPPFMBeanProviderManager;
import org.jppf.management.spi.JPPFNodeMBeanProvider;
import org.jppf.node.Node;
import org.jppf.node.NodeRunner;
import org.jppf.node.event.LifeCycleEventHandler;
import org.jppf.node.protocol.Task;
import org.jppf.server.node.AbstractClassLoaderManager;
import org.jppf.server.node.AbstractCommonNode;
import org.jppf.server.node.ClassLoaderProvider;
import org.jppf.server.node.JPPFContainer;
import org.jppf.server.node.NodeConnectionChecker;
import org.jppf.server.node.NodeExecutionManagerImpl;
import org.jppf.server.node.NodeIO;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.startup.JPPFNodeStartupSPI;
import org.jppf.startup.JPPFStartupLoader;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.Pair;
import org.jppf.utils.SerializationHelper;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JPPFNode
extends AbstractCommonNode
implements ClassLoaderProvider {
    private static final Logger log = LoggerFactory.getLogger(JPPFNode.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    protected NodeExecutionManagerImpl executionManager = null;
    protected NodeIO nodeIO = null;
    private boolean jmxEnabled = JPPFConfiguration.getProperties().getBoolean("jppf.management.enabled", true);
    private Runnable exitAction = null;
    private JPPFNodeAdminMBean nodeAdmin = null;
    private static JMXServer jmxServer = null;
    private JPPFMBeanProviderManager providerManager = null;
    protected AbstractClassLoaderManager classLoaderManager = null;
    protected LifeCycleEventHandler lifeCycleEventHandler = null;
    protected NodeConnectionChecker connectionChecker = null;
    protected final boolean checkConnection = JPPFConfiguration.getProperties().getBoolean("jppf.node.check.connection", false);

    public JPPFNode() {
        this.uuid = NodeRunner.getUuid();
        this.executionManager = new NodeExecutionManagerImpl((Node)this);
        this.lifeCycleEventHandler = new LifeCycleEventHandler((Node)this);
        this.systemInformation = new JPPFSystemInformation(this.uuid, this.isLocal(), true);
    }

    public void run() {
        this.setStopped(false);
        boolean initialized = false;
        if (debugEnabled) {
            log.debug("Start of node main loop, nodeUuid=" + this.uuid);
        }
        while (!this.isStopped()) {
            try {
                if (NodeRunner.isShuttingDown()) break;
                this.init();
                if (!initialized) {
                    System.out.println("Node successfully initialized");
                    initialized = true;
                }
                this.perform();
            }
            catch (SecurityException e) {
                this.connectionChecker.stop();
                throw new JPPFError((Throwable)e);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.checkConnection) {
                    this.connectionChecker.stop();
                }
                this.reset(true);
                throw new JPPFNodeReconnectionNotification((Throwable)e);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (this.checkConnection) {
                    this.connectionChecker.stop();
                }
                this.reset(true);
            }
        }
        if (debugEnabled) {
            log.debug("End of node main loop");
        }
        if (this.exitAction != null) {
            Runnable r = this.exitAction;
            this.setExitAction(null);
            r.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform() throws Exception {
        if (debugEnabled) {
            log.debug("Start of node secondary loop");
        }
        while (!this.isStopped()) {
            boolean notEmpty;
            Pair<JPPFTaskBundle, List<Task>> pair = this.nodeIO.readTask();
            JPPFTaskBundle bundle = (JPPFTaskBundle)pair.first();
            this.checkInitialBundle(bundle);
            List taskList = (List)pair.second();
            boolean bl = notEmpty = taskList != null && !taskList.isEmpty();
            if (debugEnabled) {
                if (notEmpty) {
                    log.debug("received a bundle with " + taskList.size() + " tasks");
                } else {
                    log.debug("received an empty bundle");
                }
            }
            if (notEmpty) {
                if (this.checkConnection) {
                    try {
                        this.connectionChecker.resume();
                        this.executionManager.execute(bundle, taskList);
                    }
                    finally {
                        this.connectionChecker.suspend();
                        if (this.connectionChecker.getException() != null) {
                            throw this.connectionChecker.getException();
                        }
                    }
                } else {
                    this.executionManager.execute(bundle, taskList);
                }
            }
            this.processResults(bundle, taskList);
        }
        if (debugEnabled) {
            log.debug("End of node secondary loop");
        }
    }

    private void checkInitialBundle(JPPFTaskBundle bundle) throws Exception {
        if (JPPFTaskBundle.State.INITIAL_BUNDLE.equals((Object)bundle.getState())) {
            if (debugEnabled) {
                log.debug("setting initial bundle uuid");
            }
            bundle.setParameter((Object)BundleParameter.NODE_UUID_PARAM, this.uuid);
            if (this.isJmxEnabled()) {
                this.setupManagementParameters(bundle);
            }
        }
    }

    private void processResults(JPPFTaskBundle bundle, List<Task> taskList) throws Exception {
        if (debugEnabled) {
            log.debug("processing results for job '" + bundle.getName() + '\'');
        }
        if (this.executionManager.checkConfigChanged() || bundle.getState() == JPPFTaskBundle.State.INITIAL_BUNDLE) {
            if (debugEnabled) {
                log.debug("detected configuration change or initial bundle request, sending new system information to the server");
            }
            TypedProperties jppf = this.systemInformation.getJppf();
            jppf.clear();
            jppf.putAll((Map)JPPFConfiguration.getProperties());
            bundle.setParameter((Object)BundleParameter.SYSTEM_INFO_PARAM, this.systemInformation);
        }
        this.nodeIO.writeResults(bundle, taskList);
        if (taskList != null && !taskList.isEmpty()) {
            if (!this.isJmxEnabled()) {
                this.setTaskCount(this.getTaskCount() + taskList.size());
            }
            if (debugEnabled) {
                log.debug("tasks executed: " + this.getTaskCount());
            }
        }
    }

    private synchronized void init() throws Exception {
        if (debugEnabled) {
            log.debug("start node initialization");
        }
        this.initHelper();
        if (this.isJmxEnabled()) {
            JMXServer jmxServer = null;
            try {
                jmxServer = this.getJmxServer();
                if (!jmxServer.getServer().isRegistered(new ObjectName("org.jppf:name=admin,type=node"))) {
                    this.registerProviderMBeans();
                }
            }
            catch (Exception e) {
                this.jmxEnabled = false;
                System.out.println("JMX initialization failure - management is disabled for this node");
                System.out.println("see the log file for details");
                try {
                    if (jmxServer != null) {
                        jmxServer.stop();
                    }
                }
                catch (Exception e2) {
                    log.error("Error stopping the JMX server", (Throwable)e2);
                }
                jmxServer = null;
                log.error("Error creating the JMX server", (Throwable)e);
            }
        }
        new JPPFStartupLoader().load(JPPFNodeStartupSPI.class);
        this.initDataChannel();
        if (this.checkConnection) {
            this.connectionChecker = this.createConnectionChecker();
            this.connectionChecker.start();
        }
        this.lifeCycleEventHandler.loadListeners();
        this.lifeCycleEventHandler.fireNodeStarting();
        if (debugEnabled) {
            log.debug("end node initialization");
        }
    }

    protected abstract void initDataChannel() throws Exception;

    protected abstract void closeDataChannel() throws Exception;

    public AbstractJPPFClassLoader getClassLoader() {
        return this.classLoaderManager.getClassLoader();
    }

    public void setClassLoader(JPPFClassLoader cl) {
        this.classLoaderManager.setClassLoader(cl);
    }

    public void initHelper() throws Exception {
        if (debugEnabled) {
            log.debug("Initializing serializer");
        }
        Class c = this.getClassLoader().loadJPPFClass("org.jppf.utils.ObjectSerializerImpl");
        if (debugEnabled) {
            log.debug("Loaded serializer class " + c);
        }
        Object o = c.newInstance();
        this.serializer = (ObjectSerializer)o;
        c = this.getClassLoader().loadJPPFClass("org.jppf.utils.SerializationHelperImpl");
        if (debugEnabled) {
            log.debug("Loaded helper class " + c);
        }
        o = c.newInstance();
        this.helper = (SerializationHelper)o;
        if (debugEnabled) {
            log.debug("Serializer initialized");
        }
    }

    public JPPFContainer getContainer(List<String> uuidPath) throws Exception {
        return this.classLoaderManager.getContainer(uuidPath);
    }

    public synchronized JPPFNodeAdminMBean getNodeAdmin() {
        return this.nodeAdmin;
    }

    public synchronized void setNodeAdmin(JPPFNodeAdminMBean nodeAdmin) {
        this.nodeAdmin = nodeAdmin;
    }

    public NodeExecutionManagerImpl getExecutionManager() {
        return this.executionManager;
    }

    boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public synchronized void stopNode() {
        if (debugEnabled) {
            log.debug("stopping node");
        }
        this.setStopped(true);
        this.executionManager.shutdown();
        try {
            this.closeDataChannel();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.reset(false);
    }

    public void shutdown(boolean restart) {
        NodeRunner.setShuttingDown((boolean)true);
        this.lifeCycleEventHandler.fireNodeEnding();
        NodeRunner.shutdown((Node)this, (boolean)restart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset(boolean stopJmx) {
        this.lifeCycleEventHandler.fireNodeEnding();
        this.lifeCycleEventHandler.removeAllListeners();
        this.setNodeAdmin(null);
        this.classLoaderManager.closeClassLoader();
        try {
            JPPFNode jPPFNode = this;
            synchronized (jPPFNode) {
                this.closeDataChannel();
            }
            this.classLoaderManager.clearContainers();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (stopJmx) {
            try {
                this.providerManager.unregisterProviderMBeans();
                if (jmxServer != null) {
                    jmxServer.stop();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public synchronized void setExitAction(Runnable exitAction) {
        this.exitAction = exitAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProviderMBeans() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        ClassLoader tmp = Thread.currentThread().getContextClassLoader();
        MBeanServer server = this.getJmxServer().getServer();
        if (this.providerManager == null) {
            this.providerManager = new JPPFMBeanProviderManager<JPPFNodeMBeanProvider>(JPPFNodeMBeanProvider.class, server);
        }
        try {
            Thread.currentThread().setContextClassLoader(cl);
            List list = this.providerManager.getAllProviders(cl);
            for (JPPFNodeMBeanProvider provider : list) {
                Object o = provider.createMBean((Node)this);
                Class<?> inf = Class.forName(provider.getMBeanInterfaceName());
                boolean b = this.providerManager.registerProviderMBean(o, inf, provider.getMBeanName());
                if (!debugEnabled) continue;
                log.debug("MBean registration " + (b ? "succeeded" : "failed") + " for [" + provider.getMBeanName() + ']');
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMXServer getJmxServer() throws Exception {
        JPPFNode jPPFNode = this;
        synchronized (jPPFNode) {
            if (jmxServer == null || jmxServer.isStopped()) {
                boolean ssl = JPPFConfiguration.getProperties().getBoolean("jppf.ssl.enabled", false);
                jmxServer = JMXServerFactory.createServer((String)NodeRunner.getUuid(), (boolean)ssl);
                jmxServer.start(this.getClass().getClassLoader());
                System.out.println("JPPF Node management initialized");
            }
        }
        return jmxServer;
    }

    public LifeCycleEventHandler getLifeCycleEventHandler() {
        return this.lifeCycleEventHandler;
    }

    @Override
    public ClassLoader getClassLoader(List<String> uuidPath) throws Exception {
        return this.classLoaderManager.getContainer(uuidPath).getClassLoader();
    }

    protected abstract NodeConnectionChecker createConnectionChecker();

    public void triggerConfigChanged() {
        this.updateSystemInformation();
        this.executionManager.triggerConfigChanged();
    }
}

