/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.jppf.node.NodeExecutionInfo;
import org.jppf.node.ThreadManager;

public abstract class AbstractThreadManager
implements ThreadManager {
    protected ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    protected boolean cpuTimeEnabled = this.threadMXBean.isThreadCpuTimeSupported();

    protected AbstractThreadManager() {
        if (this.cpuTimeEnabled) {
            this.threadMXBean.setThreadCpuTimeEnabled(true);
        }
    }

    public NodeExecutionInfo computeExecutionInfo() {
        long[] ids;
        NodeExecutionInfo info = new NodeExecutionInfo();
        for (long id : ids = this.getThreadIds()) {
            info.add(this.computeExecutionInfo(id));
        }
        return info;
    }

    public NodeExecutionInfo computeExecutionInfo(long threadID) {
        return !this.cpuTimeEnabled ? new NodeExecutionInfo() : new NodeExecutionInfo(this.threadMXBean.getThreadCpuTime(threadID), this.threadMXBean.getThreadUserTime(threadID));
    }

    protected abstract long[] getThreadIds();

    public long getCpuTime(long threadId) {
        return this.cpuTimeEnabled ? this.threadMXBean.getThreadCpuTime(threadId) : -1L;
    }

    public boolean isCpuTimeEnabled() {
        return this.cpuTimeEnabled;
    }
}

