/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.io.InvalidClassException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.node.protocol.Task;
import org.jppf.server.node.JPPFNode;
import org.jppf.server.node.NodeIO;
import org.jppf.server.protocol.BundleParameter;
import org.jppf.server.protocol.JPPFExceptionResult;
import org.jppf.server.protocol.JPPFTask;
import org.jppf.server.protocol.JPPFTaskBundle;
import org.jppf.task.storage.DataProvider;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;
import org.jppf.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeIO
implements NodeIO {
    private static Logger log = LoggerFactory.getLogger(AbstractNodeIO.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    protected final JPPFNode node;
    protected JPPFTaskBundle currentBundle = null;
    protected ObjectSerializer serializer = null;

    public AbstractNodeIO(JPPFNode node) {
        this.node = node;
    }

    @Override
    public Pair<JPPFTaskBundle, List<Task>> readTask() throws Exception {
        Object[] result = this.readObjects();
        this.currentBundle = (JPPFTaskBundle)result[0];
        LinkedList<JPPFTask> taskList = new LinkedList<JPPFTask>();
        if (!JPPFTaskBundle.State.INITIAL_BUNDLE.equals((Object)this.currentBundle.getState()) && this.currentBundle.getParameter((Object)BundleParameter.NODE_EXCEPTION_PARAM) == null) {
            DataProvider dataProvider = (DataProvider)result[1];
            for (int i = 0; i < this.currentBundle.getTaskCount(); ++i) {
                JPPFTask task = (JPPFTask)result[2 + i];
                task.setDataProvider(dataProvider);
                task.setInNode(true);
                taskList.add(task);
            }
        }
        return new Pair((Object)this.currentBundle, taskList);
    }

    protected Object[] readObjects() throws Exception {
        boolean reload;
        Object[] result;
        block6: {
            result = null;
            reload = false;
            try {
                result = this.deserializeObjects();
            }
            catch (IncompatibleClassChangeError err) {
                reload = true;
                if (debugEnabled) {
                    log.debug(err.getMessage() + "; reloading classes", (Throwable)err);
                }
            }
            catch (InvalidClassException e) {
                reload = true;
                if (!debugEnabled) break block6;
                log.debug(e.getMessage() + "; reloading classes", (Throwable)e);
            }
        }
        if (reload) {
            if (debugEnabled) {
                log.debug("reloading classes");
            }
            this.handleReload();
            result = this.deserializeObjects();
        }
        return result;
    }

    protected abstract void handleReload() throws Exception;

    protected abstract Object[] deserializeObjects() throws Exception;

    protected abstract Object[] deserializeObjects(JPPFTaskBundle var1) throws Exception;

    @Override
    public abstract void writeResults(JPPFTaskBundle var1, List<Task> var2) throws Exception;

    protected void initializePerformanceData(JPPFTaskBundle bundle) {
        bundle.setNodeExecutionTime(System.nanoTime());
    }

    protected void finalizePerformanceData(JPPFTaskBundle bundle) {
        long elapsed = System.nanoTime() - bundle.getNodeExecutionTime();
        bundle.setNodeExecutionTime(elapsed);
    }

    protected class ObjectSerializationTask
    implements Callable<DataLocation> {
        private final Object object;

        public ObjectSerializationTask(Object object) {
            this.object = object;
        }

        @Override
        public DataLocation call() {
            ObjectSerializer ser = null;
            DataLocation dl = null;
            int p = this.object instanceof JPPFTask ? ((JPPFTask)this.object).getPosition() : -1;
            try {
                ser = AbstractNodeIO.this.node.getHelper().getSerializer();
                if (traceEnabled) {
                    log.trace("before serialization of object at position " + p);
                }
                dl = IOHelper.serializeData((Object)this.object, (ObjectSerializer)ser);
                if (traceEnabled) {
                    log.trace("serialized object at position " + p);
                }
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
                try {
                    JPPFExceptionResult result = new JPPFExceptionResult(t, this.object);
                    result.setPosition(p);
                    dl = IOHelper.serializeData((Object)result, (ObjectSerializer)ser);
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
            return dl;
        }
    }

    protected static class BufferList
    extends Pair<List<JPPFBuffer>, Integer> {
        public BufferList(List<JPPFBuffer> first, Integer second) {
            super(first, (Object)second);
        }
    }
}

