/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.node;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jppf.classloader.AbstractJPPFClassLoader;
import org.jppf.classloader.JPPFClassLoader;
import org.jppf.classloader.JPPFLeakPrevention;
import org.jppf.server.node.JPPFContainer;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassLoaderManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractClassLoaderManager.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    private final int maxContainers;
    private AbstractJPPFClassLoader classLoader = null;
    private final Map<String, JPPFContainer> containerMap = new HashMap<String, JPPFContainer>();
    private final LinkedList<JPPFContainer> containerList = new LinkedList();
    private final JPPFLeakPrevention leakPrevention;

    protected AbstractClassLoaderManager() {
        TypedProperties config = JPPFConfiguration.getProperties();
        this.maxContainers = config.getInt("jppf.classloader.cache.size", 50);
        this.leakPrevention = new JPPFLeakPrevention(config);
    }

    public synchronized AbstractJPPFClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = this.createClassLoader();
        }
        return this.classLoader;
    }

    protected abstract AbstractJPPFClassLoader createClassLoader();

    public synchronized void setClassLoader(JPPFClassLoader cl) {
        this.classLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeClassLoader() {
        if (this.classLoader != null) {
            try {
                this.classLoader.close();
            }
            finally {
                this.classLoader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JPPFContainer getContainer(final List<String> uuidPath) throws Exception {
        String uuid = uuidPath.get(0);
        JPPFContainer container = this.containerMap.get(uuid);
        if (container == null) {
            if (debugEnabled) {
                log.debug("Creating new container for appuuid=" + uuid);
            }
            AbstractJPPFClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<AbstractJPPFClassLoader>(){

                @Override
                public AbstractJPPFClassLoader run() {
                    try {
                        return AbstractClassLoaderManager.this.newClassLoaderCreator(uuidPath).call();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
            });
            container = this.newJPPFContainer(uuidPath, cl);
            if (this.containerList.size() >= this.maxContainers) {
                JPPFContainer toRemove = this.containerList.removeFirst();
                try {
                    AbstractJPPFClassLoader loader = toRemove.getClassLoader();
                    if (loader != null) {
                        this.leakPrevention.clearReferences((ClassLoader)loader);
                    }
                }
                finally {
                    toRemove.helper = null;
                    toRemove.classLoader = null;
                    this.containerMap.remove(toRemove.getAppUuid());
                }
            }
            this.containerList.add(container);
            this.containerMap.put(uuid, container);
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clearContainers() {
        this.closeClassLoader();
        try {
            for (JPPFContainer container : this.containerList) {
                AbstractJPPFClassLoader loader = container.getClassLoader();
                if (loader == null) continue;
                this.leakPrevention.clearReferences((ClassLoader)loader);
            }
        }
        finally {
            this.containerMap.clear();
            this.containerList.clear();
        }
    }

    protected abstract JPPFContainer newJPPFContainer(List<String> var1, AbstractJPPFClassLoader var2) throws Exception;

    protected abstract Callable<AbstractJPPFClassLoader> newClassLoaderCreator(List<String> var1);
}

