/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.NioState;
import org.jppf.server.nio.StateTransitionManager;
import org.jppf.utils.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransitionTask<S extends Enum<S>, T extends Enum<T>>
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(StateTransitionTask.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private final ChannelWrapper<?> channel;
    private final NioServerFactory<S, T> factory;

    public StateTransitionTask(ChannelWrapper<?> channel, NioServerFactory<S, T> factory) {
        this.channel = channel;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StateTransitionManager<S, Object> transitionManager = this.factory.getServer().getTransitionManager();
        NioContext ctx = this.channel.getContext();
        try {
            Object transition = null;
            ChannelWrapper<?> channelWrapper = this.channel;
            synchronized (channelWrapper) {
                NioState<T> state = this.factory.getState(ctx.getState());
                if (traceEnabled) {
                    log.trace("performing transition to state " + ctx.getState() + " for " + this.channel);
                }
                if ((transition = (Object)state.performTransition(this.channel)) != null) {
                    transitionManager.transitionChannel(this.channel, transition, transitionManager.checkSubmitTransition(this.channel, transition));
                }
            }
        }
        catch (Exception e) {
            String msg = "error on channel " + this.channel + " : " + ExceptionUtils.getMessage((Throwable)e);
            if (debugEnabled) {
                log.debug(msg, (Throwable)e);
            } else {
                log.warn(msg);
            }
            ctx.handleException(this.channel, e);
        }
    }
}

