/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioConstants;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.NioTransition;
import org.jppf.server.nio.SSLHandler;
import org.jppf.server.nio.SelectionKeyWrapper;
import org.jppf.server.nio.StateTransitionTask;
import org.jppf.utils.ExceptionUtils;
import org.jppf.utils.JPPFThreadFactory;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransitionManager<S extends Enum<S>, T extends Enum<T>> {
    private static Logger log = LoggerFactory.getLogger(StateTransitionManager.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected ExecutorService executor = null;
    private final NioServer<S, T> server;

    public StateTransitionManager(NioServer<S, T> server) {
        this.server = server;
        this.executor = Executors.newFixedThreadPool(NioConstants.THREAD_POOL_SIZE, (ThreadFactory)new JPPFThreadFactory(server.getName()));
    }

    public void submitTransition(ChannelWrapper<?> key) {
        this.setKeyOps(key, 0);
        StateTransitionTask<S, T> transition = new StateTransitionTask<S, T>(key, this.server.getFactory());
        this.executor.submit(transition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKeyOps(ChannelWrapper<?> key, int ops) {
        ReentrantLock lock = this.server.getLock();
        lock.lock();
        try {
            this.server.getSelector().wakeup();
            key.setKeyOps(ops);
        }
        finally {
            lock.unlock();
        }
    }

    public void transitionChannel(ChannelWrapper<?> channel, T transition) {
        this.transitionChannel(channel, transition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionChannel(ChannelWrapper<?> channel, T transition, boolean submit) {
        ReentrantLock lock = this.server.getLock();
        lock.lock();
        try {
            this.server.getSelector().wakeup();
            NioContext context = channel.getContext();
            Enum s1 = context.getState();
            NioServerFactory<Enum, T> factory = this.server.getFactory();
            NioTransition<S> t = factory.getTransition(transition);
            S s2 = t.getState();
            if (s1 != null) {
                if (!factory.isTransitionAllowed(s1, (Enum)s2)) {
                    log.warn("unauthorized transition" + this.getTransitionMessage(s1, s2, t, channel));
                } else if (debugEnabled && s1 != s2) {
                    log.debug("transition" + this.getTransitionMessage(s1, s2, t, channel));
                } else if (log.isTraceEnabled()) {
                    log.trace(this.getTransitionMessage(s1, s2, t, channel));
                }
            }
            context.setState(s2);
            if (!submit) {
                channel.setKeyOps(t.getInterestOps());
            } else {
                channel.setKeyOps(0);
                this.submitTransition(channel);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private String getTransitionMessage(S s1, S s2, NioTransition<S> t, ChannelWrapper<?> channel) {
        try {
            return StringUtils.build((Object[])new Object[]{" from ", s1, " to ", s2, " with ops=", t.getInterestOps(), " for channel ", channel});
        }
        catch (Exception e) {
            return "could not build transition message: " + ExceptionUtils.getMessage((Throwable)e);
        }
    }

    public ChannelWrapper<?> registerChannel(SocketChannel channel, NioContext context) {
        return this.registerChannel(channel, 0, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelWrapper<?> registerChannel(SocketChannel channel, int ops, NioContext context) {
        SelectionKeyWrapper wrapper = null;
        try {
            ReentrantLock lock = this.server.getLock();
            lock.lock();
            try {
                this.server.getSelector().wakeup();
                if (channel.isBlocking()) {
                    channel.configureBlocking(false);
                }
                SelectionKey key = channel.register(this.server.getSelector(), ops, context);
                wrapper = new SelectionKeyWrapper(key);
                context.setChannel((ChannelWrapper)wrapper);
            }
            finally {
                lock.unlock();
            }
        }
        catch (ClosedChannelException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return wrapper;
    }

    public boolean checkSubmitTransition(ChannelWrapper<?> channel) {
        if (channel.isLocal()) {
            return false;
        }
        SSLHandler sslHandler = channel.getContext().getSSLHandler();
        if (sslHandler == null) {
            return false;
        }
        int keyOps = channel.getKeyOps();
        boolean b = keyOps != channel.getReadyOps() && keyOps != 0 && !this.server.isIdle(channel) && (sslHandler.getApplicationReceiveBuffer().position() > 0 || sslHandler.getChannelReceiveBuffer().position() > 0);
        return b;
    }

    public boolean checkSubmitTransition(ChannelWrapper<?> channel, T transition) {
        if (channel.isLocal()) {
            return false;
        }
        SSLHandler sslHandler = channel.getContext().getSSLHandler();
        if (sslHandler == null) {
            return false;
        }
        int keyOps = this.server.getFactory().getTransition(transition).getInterestOps();
        boolean b = keyOps != channel.getReadyOps() && keyOps != 0 && !this.server.isIdle(channel) && (sslHandler.getApplicationReceiveBuffer().position() > 0 || sslHandler.getChannelReceiveBuffer().position() > 0);
        return b;
    }
}

