/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.io.Closeable;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jppf.io.DataLocation;
import org.jppf.io.MultipleBuffersLocation;
import org.jppf.server.nio.AbstractNioObject;
import org.jppf.server.nio.SSLHandler;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLNioObject
extends AbstractNioObject {
    private static Logger log = LoggerFactory.getLogger(SSLNioObject.class);
    private static boolean traceEnabled = log.isTraceEnabled();
    private InputStream is;
    private OutputStream os;
    private SSLHandler sslHandler;
    private int statefulCount = 0;

    public SSLNioObject(int size, SSLHandler sslHandler) throws Exception {
        this((DataLocation)new MultipleBuffersLocation(size), sslHandler);
    }

    public SSLNioObject(DataLocation location, SSLHandler sslHandler) throws Exception {
        this.location = location;
        this.size = location.getSize();
        this.sslHandler = sslHandler;
    }

    @Override
    public boolean read() throws Exception {
        boolean b;
        if (this.count >= this.size) {
            return true;
        }
        ByteBuffer buf = this.sslHandler.getApplicationReceiveBuffer();
        if (this.os == null) {
            this.os = this.location.getOutputStream();
        }
        int n = 0;
        while (this.count < this.size) {
            if (buf.position() <= 0) {
                n = this.sslHandler.read();
                if (n == 0) {
                    return false;
                }
                if (n < 0) {
                    throw new EOFException();
                }
            }
            buf.flip();
            if (traceEnabled) {
                log.trace("n1=" + n + ", count=" + this.count + ", size=" + this.size + ", buf=" + buf);
            }
            n = Math.min(buf.remaining(), this.size - this.count);
            this.os.write(buf.array(), 0, n);
            this.count += n;
            buf.position(n);
            if (traceEnabled) {
                log.trace("n2=" + n + " count=" + this.count + ", size=" + this.size + ", buf=" + buf);
            }
            buf.compact();
            if (!traceEnabled) continue;
            log.trace("after compact(): buf=" + buf + ", netRcvBuf=" + this.sslHandler.getChannelReceiveBuffer());
        }
        boolean bl = b = this.count >= this.size;
        if (b) {
            StreamUtils.close((Closeable)this.os, (Logger)log);
            this.os = null;
        }
        return b;
    }

    @Override
    public boolean write() throws Exception {
        boolean b;
        int n;
        if (this.count >= this.size) {
            return true;
        }
        ByteBuffer buf = this.sslHandler.getApplicationSendBuffer();
        if (this.is == null) {
            this.is = this.location.getInputStream();
            this.statefulCount = 0;
        }
        if (buf.hasRemaining() && this.statefulCount < this.size) {
            int min = Math.min(this.size - this.statefulCount, buf.remaining());
            int read = this.is.read(buf.array(), buf.position(), min);
            if (read > 0) {
                this.statefulCount += read;
                buf.position(buf.position() + read);
            }
        }
        do {
            if ((n = this.sslHandler.write()) > 0) {
                this.count += n;
            }
            this.sslHandler.flush();
        } while (n > 0);
        boolean bl = b = this.count >= this.size;
        if (b) {
            this.sslHandler.flush();
            buf.clear();
            StreamUtils.close((Closeable)this.is, (Logger)log);
            this.is = null;
        }
        return b;
    }
}

