/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.jppf.io.ChannelInputSource;
import org.jppf.io.ChannelOutputDestination;
import org.jppf.io.DataLocation;
import org.jppf.io.InputSource;
import org.jppf.io.MultipleBuffersLocation;
import org.jppf.io.OutputDestination;
import org.jppf.server.nio.AbstractNioObject;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.SelectionKeyWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainNioObject
extends AbstractNioObject {
    private static Logger log = LoggerFactory.getLogger(PlainNioObject.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private boolean blocking = false;
    private InputSource source = null;
    private OutputDestination dest = null;
    private ChannelWrapper<?> channel = null;

    public PlainNioObject(ChannelWrapper<?> channel, int size, boolean blocking) {
        this(channel, (DataLocation)new MultipleBuffersLocation(size), blocking);
    }

    public PlainNioObject(ChannelWrapper<?> channel, DataLocation location, boolean blocking) {
        this.channel = channel;
        this.size = location.getSize();
        this.location = location;
    }

    @Override
    public boolean read() throws Exception {
        if (this.source == null) {
            SocketChannel socketChannel = (SocketChannel)((SelectionKey)((SelectionKeyWrapper)this.channel).getChannel()).channel();
            this.source = new ChannelInputSource((ReadableByteChannel)socketChannel);
        }
        if (this.count >= this.size) {
            return true;
        }
        int n = this.location.transferFrom(this.source, this.blocking);
        if (n > 0) {
            this.count += n;
        }
        if (debugEnabled) {
            log.debug("read " + n + " bytes from input source, count/size = " + this.count + '/' + this.size);
        }
        if (this.count >= this.size) {
            if (debugEnabled) {
                log.debug("count = " + this.count + ", size = " + this.size);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean write() throws Exception {
        if (this.dest == null) {
            SocketChannel socketChannel = (SocketChannel)((SelectionKey)((SelectionKeyWrapper)this.channel).getChannel()).channel();
            this.dest = new ChannelOutputDestination((WritableByteChannel)socketChannel);
        }
        if (this.count >= this.size) {
            return true;
        }
        int n = this.location.transferTo(this.dest, this.blocking);
        if (n > 0) {
            this.count += n;
        }
        if (debugEnabled) {
            log.debug("wrote " + n + " bytes to output destination, count/size = " + this.count + '/' + this.size + " (dl = " + this.location + ')');
        }
        if (this.count > this.size) {
            boolean bl = false;
        }
        return this.count >= this.size;
    }

    @Override
    public DataLocation getData() {
        return this.location;
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

