/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.util.Map;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.NioState;
import org.jppf.server.nio.NioTransition;
import org.jppf.utils.collections.CollectionMap;

public abstract class NioServerFactory<S extends Enum<S>, T extends Enum<T>> {
    public static final int RW = 5;
    public static final int R = 1;
    public static final int W = 4;
    protected final Map<S, NioState<T>> stateMap;
    protected final Map<T, NioTransition<S>> transitionMap;
    protected final NioServer<S, T> server;
    protected final CollectionMap<S, S> allowedTransitions;

    protected NioServerFactory(NioServer<S, T> server) {
        this.server = server;
        this.stateMap = this.createStateMap();
        this.transitionMap = this.createTransitionMap();
        this.allowedTransitions = this.createAllowedTransitionsMap();
    }

    protected abstract Map<S, NioState<T>> createStateMap();

    protected abstract Map<T, NioTransition<S>> createTransitionMap();

    protected CollectionMap<S, S> createAllowedTransitionsMap() {
        return null;
    }

    public NioState<T> getState(S name) {
        return this.stateMap.get(name);
    }

    public NioTransition<S> getTransition(T name) {
        return this.transitionMap.get(name);
    }

    public NioServer<S, T> getServer() {
        return this.server;
    }

    protected NioTransition<S> transition(S state, int ops) {
        return new NioTransition<S>(state, ops);
    }

    public boolean isTransitionAllowed(S currentState, S newState) {
        return this.allowedTransitions == null || this.allowedTransitions.contains(currentState, newState);
    }
}

