/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jppf.classloader.ResourceProvider;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.SSLHandler;
import org.jppf.server.nio.SelectionKeyWrapper;
import org.jppf.server.nio.StateTransitionManager;
import org.jppf.utils.StringUtils;
import org.jppf.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioServer<S extends Enum<S>, T extends Enum<T>>
extends Thread {
    private static Logger log = LoggerFactory.getLogger(NioServer.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected Selector selector;
    protected ResourceProvider resourceProvider = new ResourceProvider();
    private AtomicBoolean stopped = new AtomicBoolean(false);
    protected int[] ports = null;
    protected int[] sslPorts = null;
    protected long selectTimeout = 0L;
    protected NioServerFactory<S, T> factory = null;
    protected ReentrantLock lock = new ReentrantLock();
    protected StateTransitionManager<S, T> transitionManager = null;
    protected final AtomicBoolean requestShutdown = new AtomicBoolean(false);
    protected SSLContext sslContext = null;

    protected NioServer(String name) throws Exception {
        super(name);
        this.selector = Selector.open();
        this.factory = this.createFactory();
        this.transitionManager = new StateTransitionManager(this);
    }

    public NioServer(int[] ports, int[] sslPorts, String name) throws Exception {
        this(name);
        this.ports = ports;
        this.sslPorts = sslPorts;
        this.init();
    }

    protected abstract NioServerFactory<S, T> createFactory();

    protected final void init() throws Exception {
        if (this.ports != null && this.ports.length != 0) {
            this.init(this.ports, false);
        }
        if (this.sslPorts != null && this.sslPorts.length != 0) {
            this.createSSLContext();
            this.init(this.sslPorts, true);
        }
    }

    private void init(int[] portsToInit, Boolean ssl) throws Exception {
        if (debugEnabled) {
            log.debug("initializing ports=[" + StringUtils.buildString((int[])portsToInit) + "], ssl=" + ssl);
        }
        for (int i = 0; i < portsToInit.length; ++i) {
            if (portsToInit[i] < 0) continue;
            ServerSocketChannel server = ServerSocketChannel.open();
            server.socket().setReceiveBufferSize(65536);
            InetSocketAddress addr = new InetSocketAddress(portsToInit[i]);
            server.socket().bind(addr);
            if (portsToInit[i] == 0) {
                portsToInit[i] = server.socket().getLocalPort();
            }
            server.configureBlocking(false);
            server.register(this.selector, 16, ssl);
            if (!debugEnabled) continue;
            log.debug("registered server channel=" + server);
        }
    }

    protected void createSSLContext() throws Exception {
    }

    protected void configureSSLEngine(SSLEngine engine) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (debugEnabled) {
            log.debug("starting server=" + this);
        }
        try {
            boolean hasTimeout;
            boolean bl = hasTimeout = this.selectTimeout > 0L;
            while (!this.isStopped() && !this.externalStopCondition()) {
                int n;
                try {
                    this.lock.lock();
                }
                finally {
                    this.lock.unlock();
                }
                int n2 = n = hasTimeout ? this.selector.select(this.selectTimeout) : this.selector.select();
                if (this.isStopped()) continue;
                if (n > 0) {
                    this.go(this.selector.selectedKeys());
                }
                this.postSelect();
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
        }
        finally {
            this.end();
        }
    }

    protected boolean externalStopCondition() {
        return this.requestShutdown.get();
    }

    public void shutdown() {
        this.requestShutdown.set(true);
    }

    public void go(Set<SelectionKey> selectedKeys) throws Exception {
        Iterator<SelectionKey> it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            try {
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    this.doAccept(key);
                    continue;
                }
                NioContext context = (NioContext)key.attachment();
                this.transitionManager.submitTransition(context.getChannel());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (key.channel() instanceof ServerSocketChannel) continue;
                try {
                    key.channel().close();
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }

    public void postSelect() {
    }

    private void doAccept(SelectionKey key) {
        SocketChannel channel;
        if (debugEnabled) {
            log.debug("accepting key=" + key);
        }
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        boolean ssl = (Boolean)key.attachment();
        try {
            channel = serverSocketChannel.accept();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return;
        }
        if (channel == null) {
            return;
        }
        try {
            channel.socket().setSendBufferSize(65536);
            channel.socket().setReceiveBufferSize(65536);
            channel.socket().setTcpNoDelay(true);
            if (channel.isBlocking()) {
                channel.configureBlocking(false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            StreamUtils.close((Closeable)channel, (Logger)log);
            return;
        }
        this.accept(channel, null, ssl);
    }

    public ChannelWrapper<?> accept(SocketChannel channel, SSLHandler sslHandler, boolean ssl) {
        if (debugEnabled) {
            log.debug("accepting channel=" + channel + ", ssl=" + ssl);
        }
        NioContext<?> context = this.createNioContext();
        SelectionKeyWrapper wrapper = null;
        try {
            if (sslHandler != null) {
                context.setSSLHandler(sslHandler);
            }
            SelectionKey selKey = channel.register(this.selector, 0, context);
            wrapper = new SelectionKeyWrapper(selKey);
            context.setChannel((ChannelWrapper)wrapper);
            if (ssl && sslHandler == null) {
                SSLEngine engine = this.sslContext.createSSLEngine(channel.socket().getInetAddress().getHostAddress(), channel.socket().getPort());
                this.configureSSLEngine(engine);
                SSLHandler newSSLHandler = new SSLHandler((ChannelWrapper)wrapper, engine);
                context.setSSLHandler(newSSLHandler);
            }
            this.postAccept((ChannelWrapper<?>)wrapper);
        }
        catch (Exception e) {
            wrapper = null;
            log.error(e.getMessage(), (Throwable)e);
        }
        return wrapper;
    }

    public abstract void postAccept(ChannelWrapper<?> var1);

    public abstract NioContext<?> createNioContext();

    public void end() {
        if (!this.isStopped()) {
            this.setStopped(true);
            this.removeAllConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllConnections() {
        if (!this.isStopped()) {
            return;
        }
        try {
            this.lock.lock();
            this.selector.wakeup();
            Set<SelectionKey> keySet = this.selector.keys();
            ArrayList<SelectableChannel> channels = new ArrayList<SelectableChannel>();
            for (SelectionKey key : keySet) {
                channels.add(key.channel());
            }
            this.selector.close();
            for (SelectableChannel channel : channels) {
                try {
                    channel.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public synchronized NioServerFactory<S, T> getFactory() {
        if (this.factory == null) {
            this.factory = this.createFactory();
        }
        return this.factory;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    protected void setStopped(boolean stopped) {
        this.stopped.set(stopped);
    }

    protected boolean isStopped() {
        return this.stopped.get();
    }

    public StateTransitionManager<S, T> getTransitionManager() {
        return this.transitionManager;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public int[] getSSLPorts() {
        return this.sslPorts;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public abstract boolean isIdle(ChannelWrapper<?> var1);
}

