/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.server.nio.AbstractLocalChannelWrapper;
import org.jppf.server.nio.ChannelSelector;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.utils.ThreadSynchronization;

public class LocalChannelSelector
extends ThreadSynchronization
implements ChannelSelector {
    private AbstractLocalChannelWrapper channel = null;

    public LocalChannelSelector(ChannelWrapper<?> channel) {
        this.channel = (AbstractLocalChannelWrapper)channel;
    }

    public boolean select() {
        return this.select(0L);
    }

    public boolean select(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        long start = System.nanoTime();
        long timeoutNanos = timeout * 1000000L;
        long elapsed = 0L;
        boolean selected = this.channel.isSelectable();
        while (!(timeout != 0L && elapsed >= timeoutNanos || selected)) {
            this.goToSleep(1000L, 0);
            elapsed = System.nanoTime() - start;
            selected = this.channel.isSelectable();
        }
        return selected;
    }

    public boolean selectNow() {
        return this.channel.isSelectable();
    }

    public ChannelWrapper<?> getChannel() {
        return this.channel;
    }
}

