/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jppf.io.DataLocation;
import org.jppf.io.IOHelper;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioMessage;
import org.jppf.server.nio.NioObject;
import org.jppf.server.nio.PlainNioObject;
import org.jppf.server.nio.SSLHandler;
import org.jppf.server.nio.SSLNioObject;
import org.jppf.utils.SerializationUtils;
import org.jppf.utils.streams.StreamUtils;

public abstract class AbstractNioMessage
implements NioMessage {
    protected int count = 0;
    protected int length = 0;
    protected List<DataLocation> locations = new ArrayList<DataLocation>();
    protected int position = 0;
    protected int nbObjects = -1;
    protected int currentLength = 0;
    protected NioObject currentLengthObject = null;
    protected NioObject currentObject = null;
    protected boolean ssl = false;
    protected SSLHandler sslHandler = null;

    protected AbstractNioMessage(boolean ssl) {
        this.ssl = ssl;
    }

    public void addLocation(DataLocation location) {
        this.locations.add(location);
    }

    public boolean read(ChannelWrapper<?> channel) throws Exception {
        if (this.nbObjects <= 0) {
            if (this.ssl) {
                this.sslHandler = channel.getContext().getSSLHandler();
            }
            if (this.position != 0) {
                this.position = 0;
            }
            if (!this.readNextObject(channel)) {
                return false;
            }
            this.afterFirstRead();
        }
        while (this.position < this.nbObjects) {
            if (this.readNextObject(channel)) continue;
            return false;
        }
        return true;
    }

    public boolean write(ChannelWrapper<?> channel) throws Exception {
        if (this.nbObjects <= 0) {
            if (this.ssl) {
                this.sslHandler = channel.getContext().getSSLHandler();
            }
            this.position = 0;
            this.beforeFirstWrite();
        }
        while (this.position < this.nbObjects) {
            if (this.writeNextObject(channel)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readNextObject(ChannelWrapper<?> channel) throws Exception {
        if (this.currentLengthObject == null) {
            NioObject nioObject = this.currentLengthObject = this.ssl ? new SSLNioObject(4, this.sslHandler) : new PlainNioObject(channel, 4, false);
        }
        if (!this.currentLengthObject.read()) {
            return false;
        }
        if (this.currentLength <= 0) {
            InputStream is = this.currentLengthObject.getData().getInputStream();
            try {
                this.currentLength = SerializationUtils.readInt((InputStream)is);
            }
            finally {
                StreamUtils.close((Closeable)is);
            }
            this.count += 4;
        }
        if (this.currentObject == null) {
            DataLocation location = IOHelper.createDataLocationMemorySensitive((int)this.currentLength);
            NioObject nioObject = this.currentObject = this.ssl ? new SSLNioObject(location, this.sslHandler) : new PlainNioObject(channel, location, false);
        }
        if (!this.currentObject.read()) {
            return false;
        }
        this.count += this.currentLength;
        this.locations.add(this.currentObject.getData());
        this.currentLengthObject = null;
        this.currentObject = null;
        this.currentLength = 0;
        ++this.position;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeNextObject(ChannelWrapper<?> channel) throws Exception {
        if (this.currentLengthObject == null) {
            this.currentLengthObject = this.ssl ? new SSLNioObject(4, this.sslHandler) : new PlainNioObject(channel, 4, false);
            OutputStream os = this.currentLengthObject.getData().getOutputStream();
            try {
                SerializationUtils.writeInt((int)this.locations.get(this.position).getSize(), (OutputStream)os);
            }
            finally {
                StreamUtils.close((Closeable)os);
            }
        }
        if (!this.currentLengthObject.write()) {
            return false;
        }
        if (this.currentObject == null) {
            DataLocation loc = this.locations.get(this.position);
            NioObject nioObject = this.currentObject = this.ssl ? new SSLNioObject(loc.copy(), this.sslHandler) : new PlainNioObject(channel, loc.copy(), false);
        }
        if (!this.currentObject.write()) {
            return false;
        }
        this.count += 4 + this.locations.get(this.position).getSize();
        ++this.position;
        this.currentLengthObject = null;
        this.currentObject = null;
        return true;
    }

    public List<DataLocation> getLocations() {
        return this.locations;
    }

    public int getLength() {
        return this.length;
    }

    protected void afterFirstRead() throws Exception {
    }

    protected void beforeFirstWrite() throws Exception {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append('[');
        sb.append("nb locations=").append(this.locations == null ? -1 : this.locations.size());
        sb.append(", position=").append(this.position);
        sb.append(", nbObjects=").append(this.nbObjects);
        sb.append(", length=").append(this.length);
        sb.append(", count=").append(this.count);
        sb.append(']');
        return sb.toString();
    }

    public boolean isSSL() {
        return this.ssl;
    }
}

