/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server;

import java.io.Serializable;
import org.jppf.utils.QueueStats;
import org.jppf.utils.StatsSnapshot;

public class JPPFStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int totalTasksExecuted = 0;
    private StatsSnapshot execution = new StatsSnapshot("execution");
    private StatsSnapshot nodeExecution = new StatsSnapshot("node execution");
    private StatsSnapshot transport = new StatsSnapshot("transport");
    private StatsSnapshot server = new StatsSnapshot("server");
    private long footprint = 0L;
    private QueueStats taskQueue = new QueueStats("task");
    private QueueStats jobQueue = new QueueStats("job");
    private StatsSnapshot jobTasks = new StatsSnapshot("job stats");
    private StatsSnapshot nodes = new StatsSnapshot("nodes");
    private StatsSnapshot idleNodes = new StatsSnapshot("idle nodes");
    private StatsSnapshot clients = new StatsSnapshot("clients");

    public JPPFStats copy() {
        JPPFStats s = new JPPFStats();
        s.totalTasksExecuted = this.totalTasksExecuted;
        s.execution = this.execution.copy();
        s.nodeExecution = this.nodeExecution.copy();
        s.transport = this.transport.copy();
        s.taskQueue = this.taskQueue.copy();
        s.jobQueue = this.jobQueue.copy();
        s.jobTasks = this.jobTasks.copy();
        s.nodes = this.nodes.copy();
        s.idleNodes = this.idleNodes.copy();
        s.clients = this.clients.copy();
        s.footprint = this.footprint;
        return s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("totalTasksExecuted : ").append(this.totalTasksExecuted).append('\n');
        sb.append(this.execution.toString());
        sb.append(this.nodeExecution.toString());
        sb.append(this.transport.toString());
        sb.append(this.taskQueue.toString());
        sb.append(this.jobQueue.toString());
        sb.append(this.jobTasks.toString());
        sb.append(this.nodes.toString());
        sb.append(this.clients.toString());
        return sb.toString();
    }

    public void setTotalTasksExecuted(int totalTasksExecuted) {
        this.totalTasksExecuted = totalTasksExecuted;
    }

    public int getTotalTasksExecuted() {
        return this.totalTasksExecuted;
    }

    public StatsSnapshot getExecution() {
        return this.execution;
    }

    public StatsSnapshot getNodeExecution() {
        return this.nodeExecution;
    }

    public StatsSnapshot getTransport() {
        return this.transport;
    }

    public StatsSnapshot getServer() {
        return this.server;
    }

    public void setFootprint(long footprint) {
        this.footprint = footprint;
    }

    public long getFootprint() {
        return this.footprint;
    }

    public StatsSnapshot getClients() {
        return this.clients;
    }

    public void reset() {
        this.totalTasksExecuted = 0;
        this.execution = new StatsSnapshot("execution");
        this.nodeExecution = new StatsSnapshot("node execution");
        this.transport = new StatsSnapshot("transport");
        this.server = new StatsSnapshot("server");
        this.footprint = 0L;
        this.taskQueue = new QueueStats("task");
        this.jobQueue = new QueueStats("job");
        this.jobTasks = new StatsSnapshot("job tasks");
        this.nodes.setMax(this.nodes.getLatest());
        this.nodes.setMin(this.nodes.getLatest());
        this.clients.setMax(this.clients.getLatest());
        this.clients.setMin(this.clients.getLatest());
        this.idleNodes.setMax(this.idleNodes.getLatest());
        this.idleNodes.setMin(this.idleNodes.getLatest());
    }

    public QueueStats getTaskQueue() {
        return this.taskQueue;
    }

    public QueueStats getJobQueue() {
        return this.jobQueue;
    }

    public StatsSnapshot getJobTasks() {
        return this.jobTasks;
    }

    public StatsSnapshot getNodes() {
        return this.nodes;
    }

    public StatsSnapshot getIdleNodes() {
        return this.idleNodes;
    }
}

