/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.queue;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.queue.JPPFQueue;
import org.jppf.queue.QueueEvent;
import org.jppf.queue.QueueListener;
import org.jppf.utils.collections.LinkedListSortedMap;
import org.jppf.utils.collections.SetSortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPPFQueue<T, U, V>
implements JPPFQueue<T, U, V> {
    private static final Logger log = LoggerFactory.getLogger(AbstractJPPFQueue.class);
    private static final boolean debugEnabled = log.isDebugEnabled();
    protected final Lock lock = new ReentrantLock();
    protected final SetSortedMap<Integer, T> sizeMap = new SetSortedMap();
    protected AtomicInteger latestMaxSize = new AtomicInteger(0);
    private final List<QueueListener<T, U, V>> queueListeners = new ArrayList<QueueListener<T, U, V>>();
    private static final Comparator<Integer> PRIORITY_COMPARATOR = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o2.compareTo(o1);
        }
    };
    protected final LinkedListSortedMap<Integer, T> priorityMap = new LinkedListSortedMap(PRIORITY_COMPARATOR);
    protected final Map<String, T> jobMap = new HashMap<String, T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueListener(QueueListener<T, U, V> listener) {
        List<QueueListener<T, U, V>> list = this.queueListeners;
        synchronized (list) {
            this.queueListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(QueueListener<T, U, V> listener) {
        List<QueueListener<T, U, V>> list = this.queueListeners;
        synchronized (list) {
            this.queueListeners.remove(listener);
        }
    }

    protected abstract int getSize(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireQueueEvent(QueueEvent<T, U, V> event) {
        List<QueueListener<T, U, V>> list = this.queueListeners;
        synchronized (list) {
            for (QueueListener<T, U, V> listener : this.queueListeners) {
                listener.newBundle(event);
            }
        }
    }

    public Lock getLock() {
        return this.lock;
    }

    @Override
    public int getMaxBundleSize() {
        return this.latestMaxSize.get();
    }

    protected void updateLatestMaxSize() {
        if (!this.sizeMap.isEmpty()) {
            this.latestMaxSize.set((Integer)this.sizeMap.lastKey());
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.priorityMap.iterator(this.lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.priorityMap.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

