/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.management.spi;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jppf.management.spi.JPPFMBeanProvider;
import org.jppf.utils.ServiceFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPPFMBeanProviderManager<S extends JPPFMBeanProvider> {
    private static Logger log = LoggerFactory.getLogger(JPPFMBeanProviderManager.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Class<S> providerClass = null;
    private List<S> providerList = null;
    private List<String> registeredMBeanNames = new Vector<String>();
    private MBeanServer server = null;

    public JPPFMBeanProviderManager(Class<S> clazz, MBeanServer server) {
        this.providerClass = clazz;
        this.server = server;
    }

    public List<S> getAllProviders() {
        return this.getAllProviders(this.getClass().getClassLoader());
    }

    public List<S> getAllProviders(ClassLoader cl) {
        if (this.providerList == null) {
            this.providerList = new LinkedList<S>();
            Iterator it = ServiceFinder.lookupProviders(this.providerClass, (ClassLoader)cl);
            while (it.hasNext()) {
                this.providerList.add(it.next());
            }
        }
        return this.providerList;
    }

    public <T> boolean registerProviderMBean(T impl, Class<T> intf, String name) {
        try {
            ObjectName objectName;
            if (debugEnabled) {
                log.debug("found MBean provider: [name=" + name + ", inf=" + intf + ", impl=" + impl.getClass().getName() + ']');
            }
            if (!this.server.isRegistered(objectName = new ObjectName(name))) {
                this.server.registerMBean(impl, objectName);
                this.registeredMBeanNames.add(name);
                return true;
            }
            log.warn("an instance of MBean [" + name + "] already exists, registration was skipped");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void unregisterProviderMBeans() {
        while (!this.registeredMBeanNames.isEmpty()) {
            String s = this.registeredMBeanNames.remove(0);
            try {
                this.server.unregisterMBean(new ObjectName(s));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

