/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.job;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jppf.job.JobEventType;
import org.jppf.job.JobInformation;
import org.jppf.management.JPPFManagementInfo;
import org.jppf.utils.ReflectionUtils;

public class JobNotification
extends Notification {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong(0L);
    private static final ObjectName SOURCE = JobNotification.createObjectName();
    private final JPPFManagementInfo nodeInfo;
    private final JobEventType eventType;
    private final JobInformation jobInfo;

    public JobNotification(JobEventType eventType, JobInformation jobInfo, JPPFManagementInfo nodeInfo, long timestamp) {
        super("jobEvent", SOURCE, INSTANCE_COUNT.incrementAndGet());
        this.eventType = eventType;
        this.jobInfo = jobInfo;
        this.nodeInfo = nodeInfo;
        this.setTimeStamp(timestamp);
    }

    public JobInformation getJobInformation() {
        return this.jobInfo;
    }

    public JPPFManagementInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public JobEventType getEventType() {
        return this.eventType;
    }

    @Override
    public String toString() {
        return ReflectionUtils.dumpObject((Object)this, ", ", true, false, new String[0]);
    }

    private static ObjectName createObjectName() {
        ObjectName name = null;
        try {
            name = new ObjectName("org.jppf:name=jobManagement,type=driver");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }
}

