/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.doc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jppf.doc.JPPFDirFilter;
import org.jppf.doc.JPPFFileFilter;
import org.jppf.doc.ParameterNames;
import org.jppf.doc.ParametersHandler;
import org.jppf.utils.FileUtils;

public class HtmlDocGenerator {
    public static final String TEMPLATE_START = "$template{";
    public static final String TEMPLATE_END = "}$";
    public static final String CONTENT_START = "$CONTENT[";
    public static final String CONTENT_END = "]CONTENT$";
    public static final String EQUALS = "=";
    public static final String QUOTE = "\"";
    public static final String COMMENT = "#";
    public static final String PARAM_START = "${";
    public static final String PARAM_END = "}";

    public void generatePage(String source, String target, String templateFolder) throws Exception {
        System.out.println("Processing source file " + source);
        String s = FileUtils.readTextFile((String)source);
        s = this.processTemplates(new HashMap<String, String>(), s, templateFolder);
        File targetFile = new File(target);
        FileUtils.mkdirs((File)targetFile);
        FileUtils.writeTextFile((String)target, (String)s);
    }

    private String processTemplates(Map<String, String> parameterMap, String content, String templateFolder) throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean end = false;
        int pos = 0;
        while (!end && pos >= 0 && pos < content.length()) {
            int index = content.indexOf(TEMPLATE_START, pos);
            if (index < 0) {
                if (pos >= content.length()) break;
                sb.append(content.substring(pos));
                break;
            }
            sb.append(content.substring(pos, index));
            pos = index;
            if ((index = content.indexOf(TEMPLATE_END, pos + TEMPLATE_START.length())) < 0) continue;
            String templateCall = content.substring(pos, index + TEMPLATE_END.length());
            sb.append(this.processTemplateCall(templateCall, parameterMap, templateFolder));
            pos = index + TEMPLATE_END.length();
        }
        return HtmlDocGenerator.processParameters(parameterMap, sb.toString());
    }

    private String processTemplateCall(String templateCall, Map<String, String> callerMap, String templateFolder) throws Exception {
        String tf;
        String templateFile;
        int pos;
        int index = pos = TEMPLATE_START.length();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        while (index > 0) {
            index = templateCall.indexOf(EQUALS, pos);
            if (index >= 0) {
                String paramName = templateCall.substring(pos, index).trim();
                String paramValue = "";
                index = templateCall.indexOf(QUOTE, pos);
                if (index < 0) {
                    throw new Exception("Missing opening quote for parameter '" + paramName + '\'');
                }
                pos = index + QUOTE.length();
                String sub = templateCall.substring(pos);
                if (sub.startsWith(CONTENT_START)) {
                    index = templateCall.indexOf("]CONTENT$\"", pos += CONTENT_START.length());
                    if (index < 0) {
                        throw new Exception("Missing closing content string for parameter '" + paramName + "' in template call: '" + templateCall + '\'');
                    }
                    paramValue = templateCall.substring(pos, index).trim();
                    paramValue = HtmlDocGenerator.processParameters(callerMap, paramValue);
                    pos = index + "]CONTENT$\"".length();
                } else {
                    pos = index + QUOTE.length();
                    if ((index = templateCall.indexOf(QUOTE, pos)) < 0) {
                        throw new Exception("Missing closing quote for parameter '" + paramName + '\'');
                    }
                    paramValue = templateCall.substring(pos, index).trim();
                    pos = index + QUOTE.length();
                }
                parameterMap.put(paramName, paramValue);
            }
            if (!templateCall.substring(pos).startsWith(TEMPLATE_END)) continue;
            pos += TEMPLATE_END.length();
            break;
        }
        if (!new File(templateFile = (tf = !templateFolder.endsWith("/") ? templateFolder + "/" : templateFolder) + (String)parameterMap.get("name") + ".html").exists()) {
            throw new Exception("Could not find template file " + templateFile);
        }
        String content = HtmlDocGenerator.readTextFileStripComments(templateFile);
        content = this.processTemplates(parameterMap, content, tf);
        content = HtmlDocGenerator.processParameters(parameterMap, content);
        return content;
    }

    private static String processParameters(Map<String, String> parameterMap, String content) throws Exception {
        String template = HtmlDocGenerator.readTextStripComments(new StringReader(content));
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            String param = PARAM_START + entry.getKey() + PARAM_END;
            template = template.replace(param, entry.getValue());
        }
        return template;
    }

    private static String readTextFileStripComments(String path) throws Exception {
        return HtmlDocGenerator.readTextStripComments(new FileReader(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readTextStripComments(Reader reader) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        try {
            String s = "";
            while (s != null) {
                s = bufferedReader.readLine();
                if (s == null) {
                    break;
                }
                String s2 = s.trim();
                if ("".equals(s2) || s2.startsWith(COMMENT)) continue;
                sb.append(s).append('\n');
            }
        }
        finally {
            bufferedReader.close();
        }
        return sb.toString();
    }

    public static void main(String ... args) {
        try {
            boolean recursive;
            File templateDir;
            File destDir;
            Map<ParameterNames, Object> parameters = new ParametersHandler().parseArguments(args);
            File sourceDir = new File((String)parameters.get((Object)ParameterNames.SOURCE_DIR));
            if (!sourceDir.exists() || !sourceDir.isDirectory()) {
                HtmlDocGenerator.showUsageAndExit("Source location must be an existing folder");
            }
            if (!(destDir = new File((String)parameters.get((Object)ParameterNames.DEST_DIR))).exists() || !destDir.isDirectory()) {
                HtmlDocGenerator.showUsageAndExit("Target location must be an existing folder");
            }
            if (!(templateDir = new File((String)parameters.get((Object)ParameterNames.TEMPLATES_DIR))).exists() || !templateDir.isDirectory()) {
                HtmlDocGenerator.showUsageAndExit("Templates location must be an existing folder");
            }
            if (recursive = ((Boolean)parameters.get((Object)ParameterNames.RECURSIVE)).booleanValue()) {
                HtmlDocGenerator.generateDocRecursive(sourceDir, destDir, templateDir, parameters);
            } else {
                HtmlDocGenerator.generateDoc(sourceDir, destDir, templateDir, parameters);
            }
        }
        catch (Exception e) {
            HtmlDocGenerator.showUsageAndExit(e.getMessage());
        }
    }

    private static void generateDocRecursive(File sourceDir, File destDir, File templateDir, Map<ParameterNames, Object> parameters) throws Exception {
        HtmlDocGenerator.generateDoc(sourceDir, destDir, templateDir, parameters);
        ArrayList<File> allSourceDirs = new ArrayList<File>();
        HtmlDocGenerator.allDirsRecursive(sourceDir, allSourceDirs, parameters);
        String rootSourceName = sourceDir.getCanonicalPath();
        String rootTargetName = destDir.getCanonicalPath();
        for (File source : allSourceDirs) {
            String s = source.getCanonicalPath().substring(rootSourceName.length());
            File target = new File(rootTargetName + s);
            HtmlDocGenerator.generateDoc(source, target, templateDir, parameters);
        }
    }

    private static void generateDoc(File sourceDir, File destDir, File templateDir, Map<ParameterNames, Object> parameters) throws Exception {
        HtmlDocGenerator docGen = new HtmlDocGenerator();
        for (File file : sourceDir.listFiles(new JPPFFileFilter((String[])parameters.get((Object)ParameterNames.FILE_INCLUDES), (String[])parameters.get((Object)ParameterNames.FILE_EXCLUDES)))) {
            FileUtils.mkdirs((File)destDir);
            String target = destDir.getPath();
            if (!target.endsWith("/") && !target.endsWith("\\")) {
                target = target + '/';
            }
            target = target + file.getName();
            docGen.generatePage(file.getPath(), target, templateDir.getPath());
        }
    }

    private static void allDirsRecursive(File root, List<File> list, Map<ParameterNames, Object> parameters) throws Exception {
        for (File file : root.listFiles(new JPPFDirFilter((String[])parameters.get((Object)ParameterNames.DIR_INCLUDES), (String[])parameters.get((Object)ParameterNames.DIR_EXCLUDES)))) {
            list.add(file);
            HtmlDocGenerator.allDirsRecursive(file, list, parameters);
        }
    }

    private static void showUsageAndExit(String msg) {
        System.err.println(msg);
        System.err.println("HtmlDocGenerator usage: java " + HtmlDocGenerator.class.getName() + " -s sourceDir -d destDir -t templatesDir");
        System.err.println("  [[-r] [-fi includedFiles] [-fe excludedFiles] [-di includedDirs] [-de excludedDirs]]");
        System.err.println("where:");
        System.err.println("-s  sourceDir is the location of the root folder with the documents sources");
        System.err.println("-d  destDir is the root folder where the converted documents are created");
        System.err.println("-t  templatesDir is the location of the root folder where the templates are");
        System.err.println("-r  specifies whether the source directory should be processed recursively");
        System.err.println("-fi specifies extensions of the files to include");
        System.err.println("    if left unspecified, default 'html, htm, php' are included");
        System.err.println("-fe specifies extensions of the files to exclude");
        System.err.println("    if left unspecified none are excluded");
        System.err.println("-di specifies the names of the directories to include");
        System.err.println("    if left unspecified all are included");
        System.err.println("-de specifies names of the directories to exclude");
        System.err.println("    if left unspecified, default 'CVS, .svn' are excluded");
        System.err.println();
        System.exit(1);
    }
}

