/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.comm.socket;

import java.net.Socket;
import org.jppf.JPPFException;
import org.jppf.comm.socket.AbstractSocketWrapper;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClient
extends AbstractSocketWrapper {
    private static Logger log = LoggerFactory.getLogger(SocketClient.class);

    public SocketClient() {
    }

    public SocketClient(String host, int port) throws Exception {
        super(host, port, null);
    }

    public SocketClient(String host, int port, ObjectSerializer serializer) throws Exception {
        super(host, port, serializer);
    }

    public SocketClient(Socket socket) throws JPPFException {
        super(socket);
    }

    public void send(Object o) throws Exception {
        JPPFBuffer buf = this.getSerializer().serialize(o);
        this.sendBytes(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object receive(int timeout) throws Exception {
        this.checkOpened();
        Object o = null;
        try {
            if (timeout > 0) {
                this.socket.setSoTimeout(timeout);
            }
            JPPFBuffer buf = this.receiveBytes(timeout);
            o = this.getSerializer().deserialize(buf);
        }
        finally {
            if (timeout > 0) {
                this.socket.setSoTimeout(0);
            }
        }
        return o;
    }

    public ObjectSerializer getSerializer() {
        if (this.serializer == null) {
            String name = "org.jppf.utils.ObjectSerializerImpl";
            try {
                this.serializer = (ObjectSerializer)Class.forName(name).newInstance();
            }
            catch (InstantiationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.serializer;
    }

    public void setSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    public String toString() {
        return "SocketClient[" + this.host + ':' + this.port + ", open=" + this.opened + ']';
    }
}

